"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicColorForm = DynamicColorForm;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _field_select = require("../field_select");
var _color_map_select = require("./color_map_select");
var _other_category_color_picker = require("./other_category_color_picker");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/color/dynamic_color_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DynamicColorForm({
  fields,
  onDynamicStyleChange,
  staticDynamicSelect,
  styleProperty,
  swatches
}) {
  const styleOptions = styleProperty.getOptions();
  const onColorMapSelect = ({
    color,
    customColorMap,
    type,
    useCustomColorMap
  }) => {
    const newColorOptions = {
      ...styleOptions,
      type
    };
    if (type === _constants.COLOR_MAP_TYPE.ORDINAL) {
      newColorOptions.useCustomColorRamp = useCustomColorMap;
      if (customColorMap) {
        newColorOptions.customColorRamp = customColorMap;
      }
      if (color) {
        newColorOptions.color = color;
      }
    } else {
      newColorOptions.useCustomColorPalette = useCustomColorMap;
      if (customColorMap) {
        newColorOptions.customColorPalette = customColorMap;
      }
      if (color) {
        newColorOptions.colorCategory = color;
      }
    }
    onDynamicStyleChange(styleProperty.getStyleName(), newColorOptions);
  };
  const onFieldChange = ({
    field
  }) => {
    if (!field) {
      return;
    }
    const {
      name,
      origin,
      type: fieldType
    } = field;
    const defaultColorMapType = _constants.CATEGORICAL_DATA_TYPES.includes(fieldType) ? _constants.COLOR_MAP_TYPE.CATEGORICAL : _constants.COLOR_MAP_TYPE.ORDINAL;
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      field: {
        name,
        origin
      },
      type: defaultColorMapType
    });
  };
  const onColorMapTypeChange = e => {
    const colorMapType = e.target.value;
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      type: colorMapType
    });
  };
  const onOtherCategoryColorChange = color => {
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      otherCategoryColor: color
    });
  };
  const onInvertChange = event => {
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      invert: event.target.checked
    });
  };
  const getField = () => {
    const fieldName = styleProperty.getFieldName();
    if (!fieldName) {
      return null;
    }
    return fields.find(field => {
      return field.name === fieldName;
    });
  };
  const renderColorMapSelect = () => {
    const field = getField();
    if (!field) {
      return null;
    }
    const invert = styleOptions.invert === undefined ? false : styleOptions.invert;
    const showColorMapTypeToggle = !_constants.CATEGORICAL_DATA_TYPES.includes(field.type);
    return styleProperty.isOrdinal() ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_color_map_select.ColorMapSelect, {
      isCustomOnly: !field.supportsAutoDomain,
      onChange: onColorMapSelect,
      onColorMapTypeChange: onColorMapTypeChange,
      colorMapType: _constants.COLOR_MAP_TYPE.ORDINAL,
      colorPaletteId: styleOptions.color,
      customColorMap: styleOptions.customColorRamp,
      useCustomColorMap: _lodash.default.get(styleOptions, 'useCustomColorRamp', false),
      styleProperty: styleProperty,
      showColorMapTypeToggle: showColorMapTypeToggle,
      swatches: swatches,
      invert: invert,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }), !!styleOptions.useCustomColorRamp ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.style.revereseColorsLabel', {
        defaultMessage: `Reverse colors`
      }),
      checked: invert,
      onChange: onInvertChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 13
      }
    }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_color_map_select.ColorMapSelect, {
      isCustomOnly: !field.supportsAutoDomain,
      onColorMapTypeChange: onColorMapTypeChange,
      onChange: onColorMapSelect,
      colorMapType: _constants.COLOR_MAP_TYPE.CATEGORICAL,
      colorPaletteId: styleOptions.colorCategory,
      customColorMap: styleOptions.customColorPalette,
      useCustomColorMap: _lodash.default.get(styleOptions, 'useCustomColorPalette', false),
      styleProperty: styleProperty,
      showColorMapTypeToggle: showColorMapTypeToggle,
      swatches: swatches,
      invert: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_other_category_color_picker.OtherCategoryColorPicker, {
      onChange: onOtherCategoryColorChange,
      color: styleOptions.otherCategoryColor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 9
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mapStyleSettings__fixedBox",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, staticDynamicSelect ? staticDynamicSelect : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    styleName: styleProperty.getStyleName(),
    fields: fields,
    selectedFieldName: styleProperty.getFieldName(),
    onChange: onFieldChange,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), renderColorMapSelect());
}