"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicIconProperty = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _dynamic_style_property = require("./dynamic_style_property");
var _symbol_utils = require("../symbol_utils");
var _breaked_legend = require("../components/legend/breaked_legend");
var _style_util = require("../style_util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/properties/dynamic_icon_property.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class DynamicIconProperty extends _dynamic_style_property.DynamicStyleProperty {
  isOrdinal() {
    return false;
  }
  isCategorical() {
    return true;
  }
  getNumberOfCategories() {
    const palette = (0, _symbol_utils.getIconPalette)(this._options.iconPaletteId);
    return palette.length;
  }
  syncIconWithMb(symbolLayerId, mbMap) {
    if (this._isIconDynamicConfigComplete()) {
      mbMap.setLayoutProperty(symbolLayerId, 'icon-image', this._getMbIconImageExpression());
      mbMap.setLayoutProperty(symbolLayerId, 'icon-anchor', this._getMbIconAnchorExpression());
    } else {
      mbMap.setLayoutProperty(symbolLayerId, 'icon-image', null);
      mbMap.setLayoutProperty(symbolLayerId, 'icon-anchor', null);
    }
  }
  _getPaletteStops() {
    if (this._options.useCustomIconMap && this._options.customIconStops) {
      const stops = [];
      for (let i = 1; i < this._options.customIconStops.length; i++) {
        const {
          stop,
          icon,
          iconSource
        } = this._options.customIconStops[i];
        stops.push({
          stop,
          style: icon,
          iconSource
        });
      }
      return {
        fallbackSymbolId: this._options.customIconStops.length > 0 ? this._options.customIconStops[0].icon : null,
        stops
      };
    }
    return (0, _style_util.assignCategoriesToPalette)({
      categories: this.getCategoryFieldMeta(),
      paletteValues: (0, _symbol_utils.getIconPalette)(this._options.iconPaletteId)
    });
  }
  _getMbIconImageExpression() {
    const {
      stops,
      fallbackSymbolId
    } = this._getPaletteStops();
    if (stops.length < 1 || !fallbackSymbolId) {
      // occurs when no data
      return null;
    }
    const mbStops = [];
    stops.forEach(({
      stop,
      style
    }) => {
      mbStops.push(`${stop}`);
      mbStops.push(style);
    });
    if (fallbackSymbolId) {
      mbStops.push(fallbackSymbolId); // last item is fallback style for anything that does not match provided stops
    }
    return ['match', ['to-string', ['get', this.getMbFieldName()]], ...mbStops];
  }
  _getMbIconAnchorExpression() {
    const {
      stops,
      fallbackSymbolId
    } = this._getPaletteStops();
    if (stops.length < 1 || !fallbackSymbolId) {
      // occurs when no data
      return null;
    }
    const mbStops = [];
    stops.forEach(({
      stop,
      style
    }) => {
      mbStops.push(`${stop}`);
      mbStops.push((0, _symbol_utils.getMakiSymbolAnchor)(style));
    });
    if (fallbackSymbolId) {
      mbStops.push((0, _symbol_utils.getMakiSymbolAnchor)(fallbackSymbolId)); // last item is fallback style for anything that does not match provided stops
    }
    return ['match', ['to-string', ['get', this.getMbFieldName()]], ...mbStops];
  }
  _isIconDynamicConfigComplete() {
    return this._field && this._field.isValid();
  }
  renderLegendDetailRow({
    isPointsOnly,
    isLinesOnly
  }) {
    const {
      stops,
      fallbackSymbolId
    } = this._getPaletteStops();
    const breaks = [];
    const layerStyle = this._layer.getCurrentStyle();
    stops.forEach(({
      stop,
      style
    }) => {
      if (stop) {
        const svg = layerStyle.getIconSvg(style);
        breaks.push({
          color: 'grey',
          label: this.formatField(stop),
          symbolId: style,
          svg
        });
      }
    });
    if (fallbackSymbolId) {
      const svg = layerStyle.getIconSvg(fallbackSymbolId);
      breaks.push({
        color: 'grey',
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "success",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 16
          }
        }, _style_util.OTHER_CATEGORY_LABEL),
        symbolId: fallbackSymbolId,
        svg
      });
    }
    return /*#__PURE__*/_react.default.createElement(_breaked_legend.BreakedLegend, {
      style: this,
      breaks: breaks,
      isPointsOnly: isPointsOnly,
      isLinesOnly: isLinesOnly,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    });
  }
}
exports.DynamicIconProperty = DynamicIconProperty;