"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaskExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _mask_editor = require("./mask_editor");
var _es_agg_source = require("../../../classes/sources/es_agg_source");
var _mask = require("../../../classes/layers/vector_layer/mask");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/components/metrics_editor/mask_expression/mask_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class MaskExpression extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  _getMaskExpressionValue() {
    return this.props.metric.mask === undefined ? '...' : (0, _mask.getMaskI18nValue)(this.props.metric.mask.operator, this.props.metric.mask.value);
  }
  _getAggLabel() {
    const aggDisplayName = (0, _es_agg_source.getAggDisplayName)(this.props.metric.type);
    if (this.props.metric.type === _constants.AGG_TYPE.COUNT || this.props.metric.field === undefined) {
      return aggDisplayName;
    }
    const targetField = this.props.fields.find(field => field.name === this.props.metric.field);
    const fieldDisplayName = targetField !== null && targetField !== void 0 && targetField.displayName ? targetField === null || targetField === void 0 ? void 0 : targetField.displayName : this.props.metric.field;
    return `${aggDisplayName} ${fieldDisplayName}`;
  }
  render() {
    // masks only supported for numerical metrics
    if (this.props.metric.type === _constants.AGG_TYPE.TERMS) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "mask",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        color: "subdued",
        description: (0, _mask.getMaskI18nDescription)({
          aggLabel: this._getAggLabel(),
          isJoin: this.props.isJoin
        }),
        value: this._getMaskExpressionValue(),
        onClick: this._togglePopover,
        uppercase: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 11
        }
      }),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      panelPaddingSize: "s",
      anchorPosition: "downCenter",
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_mask_editor.MaskEditor, {
      metric: this.props.metric,
      onChange: this.props.onChange,
      onClose: this._closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }));
  }
}
exports.MaskExpression = MaskExpression;