"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpatialJoinExpression = SpatialJoinExpression;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _spatial_join_popover_content = require("./spatial_join_popover_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/join_editor/resources/spatial_join_expression/spatial_join_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SpatialJoinExpression(props) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    geoField
  } = props.sourceDescriptor;
  const expressionValue = geoField !== undefined ? _i18n.i18n.translate('xpack.maps.spatialJoinExpression.value', {
    defaultMessage: 'features from {geoField}',
    values: {
      geoField
    }
  }) : _i18n.i18n.translate('xpack.maps.spatialJoinExpression.emptyValue', {
    defaultMessage: '-- configure spatial join --'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: props.sourceDescriptor.id,
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    ownFocus: true,
    initialFocus: "body" /* avoid initialFocus on Combobox */,
    anchorPosition: "leftCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      description: _i18n.i18n.translate('xpack.maps.spatialJoinExpression.description', {
        defaultMessage: 'Join with'
      }),
      uppercase: false,
      value: expressionValue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }),
    repositionOnScroll: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_spatial_join_popover_content.SpatialJoinPopoverContent, {
    sourceDescriptor: props.sourceDescriptor,
    onSourceDescriptorChange: props.onSourceDescriptorChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
}