"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScaleControl = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/scale_control/scale_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_WIDTH = 110;
const getScaleDistance = value => {
  const orderOfMagnitude = Math.floor(Math.log10(value));
  const pow10 = Math.pow(10, orderOfMagnitude);
  // reduce value to single order of magnitude to making rounding simple regardless of order of magnitude
  const distance = value / pow10;
  if (distance < 1) return pow10 * (Math.round(distance * 10) / 10);
  // provide easy to multiple round numbers for scale distance so its easy to measure distances longer then the scale
  if (distance >= 10) return 10 * pow10;
  if (distance >= 5) return 5 * pow10;
  if (distance >= 3) return 3 * pow10;
  return Math.floor(distance) * pow10;
};
const componentStyles = {
  mapScaleControlStyles: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'absolute',
    zIndex: euiTheme.levels.header,
    left: euiTheme.size.m,
    bottom: euiTheme.size.m,
    pointerEvents: 'none',
    color: euiTheme.colors.textParagraph,
    borderLeft: `2px solid ${euiTheme.colors.textParagraph}99`,
    borderBottom: `2px solid ${euiTheme.colors.textParagraph}99`,
    textAlign: 'right',
    backgroundColor: euiTheme.colors.backgroundBaseSubdued,
    paddingLeft: euiTheme.size.xs,
    paddingRight: euiTheme.size.xs
  }),
  mapScaleControlFullScreenStyles: ({
    euiTheme
  }) => (0, _react2.css)({
    bottom: `calc(${euiTheme.size.l} * 2)`
  })
};
const ScaleControl = ({
  isFullScreen,
  mbMap
}) => {
  const [label, setLabel] = (0, _react.useState)('');
  const [width, setWidth] = (0, _react.useState)(0);
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const onUpdate = (0, _react.useCallback)(() => {
    const container = mbMap.getContainer();
    const centerHeight = container.clientHeight / 2;
    const leftLatLon = mbMap.unproject([0, centerHeight]);
    const rightLatLon = mbMap.unproject([MAX_WIDTH, centerHeight]);
    const maxDistanceMeters = leftLatLon.distanceTo(rightLatLon);
    const isKm = maxDistanceMeters >= 1000;
    const unit = isKm ? _i18n.i18n.translate('xpack.maps.kilometersAbbr', {
      defaultMessage: 'km'
    }) : _i18n.i18n.translate('xpack.maps.metersAbbr', {
      defaultMessage: 'm'
    });
    const maxDistance = isKm ? maxDistanceMeters / 1000 : maxDistanceMeters;
    const scaleDistance = getScaleDistance(maxDistance);
    const zoom = mbMap.getZoom();
    const bounds = mbMap.getBounds();
    let nextLabel = `${scaleDistance} ${unit}`;
    if (zoom <= 4 || zoom <= 6 && (bounds.getNorth() > 23.5 || bounds.getSouth() < -23.5) || zoom <= 8 && (bounds.getNorth() > 45 || bounds.getSouth() < -45)) {
      nextLabel = `~${nextLabel}`;
    }
    setLabel(nextLabel);
    setWidth(MAX_WIDTH * (scaleDistance / maxDistance));
  }, [mbMap]);
  (0, _react.useEffect)(() => {
    mbMap.on('move', onUpdate);
    onUpdate();
    return () => {
      mbMap.off('move', onUpdate);
    };
  }, [mbMap, onUpdate]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.mapScaleControlStyles, isFullScreen && styles.mapScaleControlFullScreenStyles],
    style: {
      width: `${width}px`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, label);
};
exports.ScaleControl = ScaleControl;