"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FitToData = FitToData;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/toolbar_overlay/fit_to_data/fit_to_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FitToData(props) {
  const label = _i18n.i18n.translate('xpack.maps.fitToData.label', {
    defaultMessage: 'Fit to data bounds'
  });
  let title = label;
  if (props.autoFitToDataBounds) {
    title = `${title}. ` + _i18n.i18n.translate('xpack.maps.fitToData.autoFitToDataBounds', {
      defaultMessage: 'Map setting "auto fit map to data bounds" enabled, map will automatically pan and zoom to show the data bounds.'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    className: "mapToolbarOverlay__button",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: (0, _classnames.default)({
      'mapToolbarOverlay__buttonIcon-empty': !props.autoFitToDataBounds
    }),
    size: "s",
    onClick: props.fitToBounds,
    "data-test-subj": "fitToData",
    iconType: "expand",
    "aria-label": label,
    title: title,
    color: "text",
    display: props.autoFitToDataBounds ? 'fill' : 'empty',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }));
}