"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigValidator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlParseInterval = require("@kbn/ml-parse-interval");
var _states = require("../../../common/constants/states");
var _alerts = require("../../../common/constants/alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_rule/config_validator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Validated alert configuration
 */
const ConfigValidator = exports.ConfigValidator = /*#__PURE__*/_react.default.memo(({
  jobConfigs = [],
  alertInterval,
  alertParams,
  alertNotifyWhen,
  maxNumberOfBuckets
}) => {
  var _parseInterval, _parseInterval2, _alertParams$topNBuck;
  if (jobConfigs.length === 0) return null;
  const alertIntervalInSeconds = (_parseInterval = (0, _mlParseInterval.parseInterval)(alertInterval)) === null || _parseInterval === void 0 ? void 0 : _parseInterval.asSeconds();
  const lookbackIntervalInSeconds = !!alertParams.lookbackInterval && ((_parseInterval2 = (0, _mlParseInterval.parseInterval)(alertParams.lookbackInterval)) === null || _parseInterval2 === void 0 ? void 0 : _parseInterval2.asSeconds());
  const isAlertIntervalTooHigh = lookbackIntervalInSeconds && alertIntervalInSeconds && lookbackIntervalInSeconds < alertIntervalInSeconds;
  const jobWithoutStartedDatafeed = jobConfigs.filter(job => job.datafeed_config.state !== _states.DATAFEED_STATE.STARTED).map(job => job.job_id);
  const configContainsIssues = isAlertIntervalTooHigh || jobWithoutStartedDatafeed.length > 0;
  const notifyWhenWarning = alertNotifyWhen === 'onActiveAlert' && lookbackIntervalInSeconds && alertIntervalInSeconds && alertIntervalInSeconds < lookbackIntervalInSeconds;
  const bucketSpanDuration = (0, _mlParseInterval.parseInterval)(jobConfigs[0].analysis_config.bucket_span);
  const notificationDuration = bucketSpanDuration ? Math.ceil(bucketSpanDuration.asMinutes()) * Math.min((_alertParams$topNBuck = alertParams.topNBuckets) !== null && _alertParams$topNBuck !== void 0 ? _alertParams$topNBuck : _alerts.TOP_N_BUCKETS_COUNT, maxNumberOfBuckets !== null && maxNumberOfBuckets !== void 0 ? maxNumberOfBuckets : _alerts.TOP_N_BUCKETS_COUNT) : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }), configContainsIssues ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.alertConditionValidation.title",
      defaultMessage: "Alert condition contains the following issues:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }),
    color: "warning",
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, isAlertIntervalTooHigh ? /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.alertConditionValidation.alertIntervalTooHighMessage",
    defaultMessage: "The check interval is greater than the lookback interval. Reduce it to {lookbackInterval} to avoid potentially missing notifications.",
    values: {
      lookbackInterval: alertParams.lookbackInterval
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 21
    }
  })) : null, jobWithoutStartedDatafeed.length > 0 ? /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.alertConditionValidation.stoppedDatafeedJobsMessage",
    defaultMessage: "The datafeed is not started for the following {count, plural, one {job} other {jobs}}: {jobIds}.",
    values: {
      count: jobWithoutStartedDatafeed.length,
      jobIds: jobWithoutStartedDatafeed.join(', ')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 21
    }
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  })) : null, notifyWhenWarning ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.alertConditionValidation.notifyWhenWarning",
      defaultMessage: "Expect to receive duplicate notifications about the same anomaly for up to {notificationDuration, plural, one {# minute} other {# minutes}}. Increase the check interval or switch to notify only on status change to avoid duplicate notifications.",
      values: {
        notificationDuration
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 17
      }
    }),
    color: "warning",
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  })) : null);
});