"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyValueDisplay = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _anomaly_value_utils = require("./anomaly_value_utils");
var _format_value = require("../../formatters/format_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/anomalies_table/anomaly_value_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AnomalyValueDisplay = ({
  value,
  function: functionName,
  record,
  fieldFormat
}) => {
  const singleValue = Array.isArray(value) ? value[0] : value;
  const timeValueInfo = (0, _anomaly_value_utils.useTimeValueInfo)(singleValue, functionName, record);

  // If the function is a time function, return the formatted value and tooltip content
  if (timeValueInfo !== null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: timeValueInfo.tooltipContent,
      position: "left",
      anchorProps: {
        'data-test-subj': 'mlAnomalyTimeValue'
      },
      "data-test-subj": "mlAnomalyTimeValueTooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timeValueInfo.formattedTime, timeValueInfo.dayOffset !== undefined && timeValueInfo.dayOffset !== 0 && /*#__PURE__*/_react.default.createElement("sub", {
      "data-test-subj": "mlAnomalyTimeValueOffset",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 13
      }
    }, timeValueInfo.dayOffset > 0 ? `+${timeValueInfo.dayOffset}` : timeValueInfo.dayOffset)));
  }

  // If the function is not a time function, return just the formatted value
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "mlAnomalyValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, (0, _format_value.formatValue)(value, functionName, fieldFormat, record));
};
exports.AnomalyValueDisplay = AnomalyValueDisplay;