"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyResultsViewSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlUrlState = require("@kbn/ml-url-state");
var _kibana = require("../../contexts/kibana");
var _locator = require("../../../../common/constants/locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/anomaly_results_view_selector/anomaly_results_view_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component for rendering a set of buttons for switching between the Anomaly Detection results views.
 */
const AnomalyResultsViewSelector = ({
  viewId,
  selectedJobs
}) => {
  const mounted = (0, _react.useRef)(false);
  const locator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const smvJobs = (selectedJobs !== null && selectedJobs !== void 0 ? selectedJobs : []).filter(job => job.isSingleMetricViewerJob);
  const isSingleMetricViewerDisabled = smvJobs.length === 0;
  const toggleButtonsIcons = (0, _react.useMemo)(() => {
    var _selectedJobs$length;
    return [{
      id: 'timeseriesexplorer',
      label: viewId === 'explorer' && isSingleMetricViewerDisabled ? _i18n.i18n.translate('xpack.ml.anomalyResultsViewSelector.singleMetricViewerDisabledLabel', {
        defaultMessage: 'Selected {jobsCount, plural, one {job is} other {jobs are}} not viewable in the Single Metric Viewer',
        values: {
          jobsCount: (_selectedJobs$length = selectedJobs === null || selectedJobs === void 0 ? void 0 : selectedJobs.length) !== null && _selectedJobs$length !== void 0 ? _selectedJobs$length : 0
        }
      }) : _i18n.i18n.translate('xpack.ml.anomalyResultsViewSelector.singleMetricViewerLabel', {
        defaultMessage: 'View results in the Single Metric Viewer'
      }),
      iconType: 'singleMetricViewer',
      value: _locator.ML_PAGES.SINGLE_METRIC_VIEWER,
      'data-test-subj': 'mlAnomalyResultsViewSelectorSingleMetricViewer',
      isDisabled: viewId === 'explorer' && isSingleMetricViewerDisabled
    }, {
      id: 'explorer',
      label: _i18n.i18n.translate('xpack.ml.anomalyResultsViewSelector.anomalyExplorerLabel', {
        defaultMessage: 'View results in the Anomaly Explorer'
      }),
      iconType: 'visTable',
      value: _locator.ML_PAGES.ANOMALY_EXPLORER,
      'data-test-subj': 'mlAnomalyResultsViewSelectorExplorer'
    }];
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [isSingleMetricViewerDisabled, selectedJobs === null || selectedJobs === void 0 ? void 0 : selectedJobs.length]);
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  (0, _react.useEffect)(() => {
    mounted.current = true;
    return () => {
      mounted.current = false;
    };
  }, []);
  const onChangeView = async newViewId => {
    // Avoid calling and triggering a React state update on a possibly unmounted component
    if (mounted.current) {
      const url = await locator.getUrl({
        page: newViewId,
        pageState: {
          globalState
        }
      });
      await navigateToPath(url);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.ml.anomalyResultsViewSelector.buttonGroupLegend', {
      defaultMessage: 'Anomaly results view selector'
    }),
    name: "anomalyResultsViewSelector",
    "data-test-subj": "mlAnomalyResultsViewSelector",
    options: toggleButtonsIcons,
    idSelected: viewId,
    onChange: newViewId => onChangeView(newViewId),
    isIconOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
};
exports.AnomalyResultsViewSelector = AnomalyResultsViewSelector;