"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableInterval = exports.TABLE_INTERVAL_DEFAULT = exports.SelectIntervalUI = exports.SelectInterval = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlUrlState = require("@kbn/ml-url-state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/controls/select_interval/select_interval.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OPTIONS = [{
  value: 'auto',
  text: _i18n.i18n.translate('xpack.ml.controls.selectInterval.autoLabel', {
    defaultMessage: 'Auto'
  })
}, {
  value: 'hour',
  text: _i18n.i18n.translate('xpack.ml.controls.selectInterval.hourLabel', {
    defaultMessage: '1 hour'
  })
}, {
  value: 'day',
  text: _i18n.i18n.translate('xpack.ml.controls.selectInterval.dayLabel', {
    defaultMessage: '1 day'
  })
}, {
  value: 'second',
  text: _i18n.i18n.translate('xpack.ml.controls.selectInterval.showAllLabel', {
    defaultMessage: 'Show all'
  })
}];
function optionValueToInterval(value) {
  // Builds the corresponding interval object with the required display and val properties
  // from the specified value.
  const option = OPTIONS.find(opt => opt.value === value);

  // Default to auto if supplied value doesn't map to one of the options.
  let interval = {
    display: OPTIONS[0].text,
    val: OPTIONS[0].value
  };
  if (option !== undefined) {
    interval = {
      display: option.text,
      val: option.value
    };
  }
  return interval;
}
const TABLE_INTERVAL_DEFAULT = exports.TABLE_INTERVAL_DEFAULT = optionValueToInterval('auto');
const useTableInterval = () => {
  const [interval, updateCallback, tableIntervalUrlStateService] = (0, _mlUrlState.usePageUrlState)('mlSelectInterval', TABLE_INTERVAL_DEFAULT);
  return [interval, updateCallback, tableIntervalUrlStateService];
};

/*
 * React component for rendering a select element with various aggregation interval levels.
 */
exports.useTableInterval = useTableInterval;
const SelectInterval = () => {
  const [interval, setInterval] = useTableInterval();
  return /*#__PURE__*/_react.default.createElement(SelectIntervalUI, {
    interval: interval,
    onChange: setInterval,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 10
    }
  });
};
exports.SelectInterval = SelectInterval;
const SelectIntervalUI = ({
  interval,
  onChange
}) => {
  const handleOnChange = e => {
    onChange(optionValueToInterval(e.target.value));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "mlAnomalyIntervalControls",
    prepend: _i18n.i18n.translate('xpack.ml.controls.selectInterval.intervalLabel', {
      defaultMessage: 'Interval'
    }),
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.ml.controls.selectInterval.intervalTooltip', {
        defaultMessage: 'Show only the highest severity anomaly for each interval (such as hour or day) or show all anomalies in the selected time period.'
      }),
      type: "question",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }),
    compressed: true,
    options: OPTIONS,
    value: interval.val,
    onChange: handleOnChange,
    "aria-label": _i18n.i18n.translate('xpack.ml.controls.selectInterval.ariaLabel', {
      defaultMessage: 'Select interval'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  });
};
exports.SelectIntervalUI = SelectIntervalUI;