"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSpaceAwareItemCheckModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _kibana = require("../../contexts/kibana");
var _toast_notification_service = require("../../services/toast_notification_service");
var _managed_jobs_warning_callout = require("../../jobs/jobs_list/components/confirm_modals/managed_jobs_warning_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/delete_space_aware_item_check_modal/delete_space_aware_item_check_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const shouldUnTagJobLabel = _i18n.i18n.translate('xpack.ml.deleteSpaceAwareItemCheckModal.shouldUnTagLabel.job', {
  defaultMessage: 'Remove job from current space'
});
const shouldUnTagModelLabel = _i18n.i18n.translate('xpack.ml.deleteSpaceAwareItemCheckModal.shouldUnTagLabel.model', {
  defaultMessage: 'Remove model from current space'
});
function getRespSummary(resp) {
  const itemsChecked = Object.keys(resp);
  // Default to first item's permissions
  const {
    canDelete,
    canRemoveFromSpace
  } = resp[itemsChecked[0]];
  let canTakeAnyAction = true;
  if (itemsChecked.length > 1) {
    // Check all jobs and make sure they have the same permissions - otherwise no action can be taken
    canTakeAnyAction = itemsChecked.every(id => resp[id].canDelete === canDelete && resp[id].canRemoveFromSpace === canRemoveFromSpace);
  }
  return {
    canDelete,
    canRemoveFromSpace,
    canTakeAnyAction
  };
}
function getModalContent(ids, mlSavedObjectType, respSummary, hasManagedJob) {
  const {
    canDelete,
    canRemoveFromSpace,
    canTakeAnyAction
  } = respSummary;
  if (canTakeAnyAction === false) {
    return {
      buttonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextNoAction",
        defaultMessage: "Close",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 9
        }
      }),
      modalText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextNoAction",
        defaultMessage: "{ids} have different space permissions. ",
        values: {
          ids: ids.join(', ')
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 11
        }
      }), mlSavedObjectType === 'trained-model' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextNoAction.model",
        defaultMessage: "When you delete multiple models, they must have the same permissions. Deselect the models and try deleting each model individually.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextNoAction.job",
        defaultMessage: "When you delete multiple jobs, they must have the same permissions. Deselect the jobs and try deleting each job individually.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 13
        }
      }))
    };
  }
  const noActionContent = {
    buttonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextClose",
      defaultMessage: "Close",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 7
      }
    }),
    modalText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextClose",
      defaultMessage: "{ids} cannot be deleted and cannot be removed from the current space. ",
      values: {
        ids: ids.join(', ')
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }), mlSavedObjectType === 'trained-model' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextClose.model",
      defaultMessage: "This model is assigned to the * space and you do not have access to all spaces.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextClose.job",
      defaultMessage: "This job is assigned to the * space and you do not have access to all spaces.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }))
  };
  if (canDelete) {
    return {
      buttonText: mlSavedObjectType === 'trained-model' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextCanDelete.model",
        defaultMessage: "Continue to delete {length, plural, one {# model} other {# models}}",
        values: {
          length: ids.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 11
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextCanDelete.job",
        defaultMessage: "Continue to delete {length, plural, one {# job} other {# jobs}}",
        values: {
          length: ids.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 11
        }
      }),
      modalText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasManagedJob ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
        jobsCount: ids.length,
        action: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobCheckModal.removeOrDeleteAction', {
          defaultMessage: 'removing or deleting'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 15
        }
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextCanDelete",
        defaultMessage: "{ids} can be deleted.",
        values: {
          ids: ids.join(', ')
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 13
        }
      })))
    };
  } else if (canRemoveFromSpace) {
    return {
      buttonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.buttonTextCanUnTagConfirm",
        defaultMessage: "Remove from current space",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 9
        }
      }),
      modalText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasManagedJob ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
        jobsCount: ids.length,
        action: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobCheckModal.removeAction', {
          defaultMessage: 'removing'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 15
        }
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTextCanUnTag",
        defaultMessage: "{ids} cannot be deleted but can be removed from the current space.",
        values: {
          ids: ids.join(', ')
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 13
        }
      })))
    };
  } else {
    return noActionContent;
  }
}
const DeleteSpaceAwareItemCheckModal = ({
  canDeleteCallback,
  onCloseCallback,
  refreshJobsCallback,
  mlSavedObjectType,
  ids,
  setDidUntag,
  hasManagedJob,
  onUntagCallback
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [buttonContent, setButtonContent] = (0, _react.useState)();
  const [modalContent, setModalContent] = (0, _react.useState)();
  const [hasUntagged, setHasUntagged] = (0, _react.useState)(false);
  const [isUntagging, setIsUntagging] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [itemCheckRespSummary, setItemCheckRespSummary] = (0, _react.useState)();
  const [showModal, setShowModal] = (0, _react.useState)(false);
  const {
    savedObjects: {
      canDeleteMLSpaceAwareItems,
      removeItemFromCurrentSpace
    }
  } = (0, _kibana.useMlApi)();
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _toast_notification_service.useToastNotificationService)();

  // delay showing the modal to avoid flickering
  (0, _useDebounce.default)(() => setShowModal(true), 1000);
  (0, _react.useEffect)(() => {
    setIsLoading(true);
    // Do the spaces check and set the content for the modal and buttons depending on results
    canDeleteMLSpaceAwareItems(mlSavedObjectType, ids).then(resp => {
      const respSummary = getRespSummary(resp);
      const {
        canDelete,
        canRemoveFromSpace,
        canTakeAnyAction
      } = respSummary;
      if (canTakeAnyAction && canDelete && !canRemoveFromSpace) {
        // Go straight to delete flow if that's the only action available
        canDeleteCallback();
        return;
      }
      setItemCheckRespSummary(respSummary);
      const {
        buttonText,
        modalText
      } = getModalContent(ids, mlSavedObjectType, respSummary, hasManagedJob);
      setButtonContent(buttonText);
      setModalContent(modalText);
      setIsLoading(false);
    });
    if (typeof setDidUntag === 'function') {
      setDidUntag(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [hasManagedJob]);
  const onUntagClick = async () => {
    setIsUntagging(true);
    const resp = await removeItemFromCurrentSpace(mlSavedObjectType, ids);
    setIsUntagging(false);
    if (typeof setDidUntag === 'function') {
      setDidUntag(true);
    }
    Object.entries(resp).forEach(([id, {
      success,
      error
    }]) => {
      if (success === false) {
        const title = _i18n.i18n.translate('xpack.ml.deleteSpaceAwareItemCheckModal.unTagErrorTitle', {
          defaultMessage: 'Error updating {id}',
          values: {
            id
          }
        });
        displayErrorToast(error, title);
      } else {
        setHasUntagged(true);
        const message = _i18n.i18n.translate('xpack.ml.deleteSpaceAwareItemCheckModal.unTagSuccessTitle', {
          defaultMessage: 'Successfully updated {id}',
          values: {
            id
          }
        });
        displaySuccessToast(message);
      }
    });
    // Close the modal
    onCloseCallback();
    if (typeof refreshJobsCallback === 'function') {
      refreshJobsCallback();
    }
    if (typeof onUntagCallback === 'function') {
      onUntagCallback();
    }
  };
  const onClick = async () => {
    if (itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canTakeAnyAction && itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canDelete) {
      canDeleteCallback();
    } else {
      onCloseCallback();
    }
  };
  if (showModal === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onCloseCallback,
    "data-test-subj": "mlDeleteSpaceAwareItemCheckModalOverlay",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalTitle",
    defaultMessage: "Checking space permissions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 13
    }
  }))), isLoading === false ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 13
    }
  }, modalContent), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 17
    }
  }, !hasUntagged && (itemCheckRespSummary === null || itemCheckRespSummary === void 0 ? void 0 : itemCheckRespSummary.canTakeAnyAction) && (itemCheckRespSummary === null || itemCheckRespSummary === void 0 ? void 0 : itemCheckRespSummary.canRemoveFromSpace) && (itemCheckRespSummary === null || itemCheckRespSummary === void 0 ? void 0 : itemCheckRespSummary.canDelete) && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isUntagging,
    color: "primary",
    size: "s",
    onClick: onUntagClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 23
    }
  }, mlSavedObjectType === 'trained-model' ? shouldUnTagModelLabel : shouldUnTagJobLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlDeleteSpaceAwareItemCheckModalOverlayCloseButton",
    size: "s",
    onClick: itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canTakeAnyAction && itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canRemoveFromSpace && !(itemCheckRespSummary !== null && itemCheckRespSummary !== void 0 && itemCheckRespSummary.canDelete) ? onUntagClick : onClick,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 19
    }
  }, buttonContent))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.deleteSpaceAwareItemCheckModal.modalDesc",
    defaultMessage: "Checking to see whether the {jobCount, plural, one {job} other {jobs}} can be deleted.",
    values: {
      jobCount: ids.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 13
    }
  }))));
};
exports.DeleteSpaceAwareItemCheckModal = DeleteSpaceAwareItemCheckModal;