"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncToAllSpacesWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana_context = require("../../contexts/kibana/kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_spaces_sync/sync_to_all_spaces_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SyncToAllSpacesWarning = () => {
  const {
    services: {
      docLinks: {
        links
      }
    }
  } = (0, _kibana_context.useMlKibana)();
  const docLink = links.security.kibanaPrivileges;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "question",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.management.syncSavedObjectsFlyout.allSpacesWarning.title",
      defaultMessage: "Sync can only add items to the current space",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }),
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.allSpacesWarning.description",
    defaultMessage: "Without {readAndWritePrivilegesLink} for all spaces you can only add jobs and trained models to the current space when syncing.",
    values: {
      readAndWritePrivilegesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLink,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.management.syncSavedObjectsFlyout.privilegeWarningLink",
        defaultMessage: "read and write privileges",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })));
};
exports.SyncToAllSpacesWarning = SyncToAllSpacesWarning;