"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/field-formats-plugin/common");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
var _ml_notifications_context = require("../../contexts/ml/ml_notifications_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/ml_page/notifications_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NotificationsIndicator = () => {
  var _notificationsCounts$, _notificationsCounts$2;
  const {
    notificationsCounts,
    latestRequestedAt
  } = (0, _ml_notifications_context.useMlNotifications)();
  const dateFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);
  const errorsAndWarningCount = ((_notificationsCounts$ = notificationsCounts === null || notificationsCounts === void 0 ? void 0 : notificationsCounts.error) !== null && _notificationsCounts$ !== void 0 ? _notificationsCounts$ : 0) + ((_notificationsCounts$2 = notificationsCounts === null || notificationsCounts === void 0 ? void 0 : notificationsCounts.warning) !== null && _notificationsCounts$2 !== void 0 ? _notificationsCounts$2 : 0);
  const hasUnread = notificationsCounts && Object.values(notificationsCounts).some(v => v > 0);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    gutterSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.navMenu.notificationsTabLinkText",
    defaultMessage: "Notifications",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })), errorsAndWarningCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.notificationsIndicator.errorsAndWarningLabel",
      defaultMessage: "There {count, plural, one {is # notification} other {are # notifications}} with error or warning level since {lastCheckedAt}",
      values: {
        count: errorsAndWarningCount,
        lastCheckedAt: dateFormatter(latestRequestedAt)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    "aria-label": _i18n.i18n.translate('xpack.ml.notificationsIndicator.unreadErrors', {
      defaultMessage: 'Unread errors or warnings indicator.'
    }),
    "data-test-subj": 'mlNotificationErrorsIndicator',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, errorsAndWarningCount))) : null, !errorsAndWarningCount && hasUnread ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.notificationsIndicator.unreadLabel",
      defaultMessage: "You have unread notifications since {lastCheckedAt}",
      values: {
        lastCheckedAt: dateFormatter(latestRequestedAt)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    css: {
      display: 'block'
    },
    color: "primary",
    role: "img",
    "aria-label": _i18n.i18n.translate('xpack.ml.notificationsIndicator.unreadIcon', {
      defaultMessage: 'Unread notifications indicator.'
    }),
    "data-test-subj": 'mlNotificationsIndicator',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }))) : null);
};
exports.NotificationsIndicator = NotificationsIndicator;