"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_data_view_form_row = require("@kbn/ml-data-view-utils/components/create_data_view_form_row");
var _shared = require("../shared");
var _page = require("../../page");
var _use_can_create_data_view = require("../../hooks/use_can_create_data_view");
var _use_data_view_time_fields = require("../../hooks/use_data_view_time_fields");
var _create_step_footer = require("../create_step_footer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/create_step/create_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateStep = ({
  actions,
  state,
  step,
  showCreateDataView = false
}) => {
  const canCreateDataView = (0, _use_can_create_data_view.useCanCreateDataView)();
  const {
    dataViewAvailableTimeFields,
    onTimeFieldChanged
  } = (0, _use_data_view_time_fields.useDataViewTimeFields)({
    actions,
    state
  });
  const {
    createAnalyticsJob,
    setFormState,
    startAnalyticsJob
  } = actions;
  const {
    isAdvancedEditorValidJson,
    isJobCreated,
    isJobStarted,
    isValid,
    requestMessages
  } = state;
  const {
    createDataView,
    destinationDataViewTitleExists,
    jobId,
    jobType,
    timeFieldName
  } = state.form;
  const [startChecked, setStartChecked] = (0, _react.useState)(true);
  const [creationTriggered, setCreationTriggered] = (0, _react.useState)(false);
  const [showProgress, setShowProgress] = (0, _react.useState)(false);
  if (step !== _page.ANALYTICS_STEPS.CREATE) return null;
  const handleCreation = async () => {
    setCreationTriggered(true);
    const creationSuccess = await createAnalyticsJob();
    if (creationSuccess === false) {
      setCreationTriggered(false);
    }
    if (startChecked && creationSuccess === true) {
      setShowProgress(true);
      startAnalyticsJob();
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlAnalyticsCreateJobWizardCreateStep active",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, !isJobCreated && !isJobStarted && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showCreateDataView && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_create_data_view_form_row.CreateDataViewForm, {
    canCreateDataView: canCreateDataView,
    createDataView: createDataView,
    dataViewTitleExists: destinationDataViewTitleExists,
    setCreateDataView: () => setFormState({
      createDataView: !createDataView
    }),
    dataViewAvailableTimeFields: dataViewAvailableTimeFields,
    dataViewTimeField: timeFieldName,
    onTimeFieldChanged: onTimeFieldChanged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.startCheckboxHelpText', {
      defaultMessage: 'If unselected, job can be started later by returning to the jobs list.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "mlAnalyticsCreateJobWizardStartJobSwitch",
    name: "mlAnalyticsCreateJobWizardStartJobSwitch",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.wizardStartCheckbox', {
      defaultMessage: 'Start immediately'
    }),
    checked: startChecked,
    onChange: e => {
      setStartChecked(e.target.checked);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: "mlAnalyticsCreateWizard__footerButton",
    disabled: !isValid || !isAdvancedEditorValidJson,
    onClick: handleCreation,
    fill: true,
    isLoading: creationTriggered,
    "data-test-subj": "mlAnalyticsCreateJobWizardCreateButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.wizardCreateButton', {
    defaultMessage: 'Create'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared.Messages, {
    messages: requestMessages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }), isJobCreated === true ? /*#__PURE__*/_react.default.createElement(_create_step_footer.CreateStepFooter, {
    jobId: jobId,
    jobType: jobType,
    showProgress: showProgress,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }) : null);
};
exports.CreateStep = CreateStep;