"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecisionPathPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _decision_path_regression = require("./decision_path_regression");
var _decision_path_json_viewer = require("./decision_path_json_viewer");
var _decision_path_classification = require("./decision_path_classification");
var _kibana = require("../../../../../contexts/kibana");
var _use_classification_path_data = require("./use_classification_path_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/feature_importance/decision_path_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var DECISION_PATH_TABS = /*#__PURE__*/function (DECISION_PATH_TABS) {
  DECISION_PATH_TABS["CHART"] = "decision_path_chart";
  DECISION_PATH_TABS["JSON"] = "decision_path_json";
  return DECISION_PATH_TABS;
}(DECISION_PATH_TABS || {});
const DecisionPathPopover = ({
  baseline,
  featureImportance,
  predictedValue,
  topClasses,
  analysisType,
  predictionFieldName,
  predictedProbability
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(DECISION_PATH_TABS.CHART);
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const docLink = docLinks.links.ml.featureImportance;
  if (featureImportance.length < 2) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlDFADecisionPathJSONViewer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_decision_path_json_viewer.DecisionPathJSONViewer, {
      featureImportance: featureImportance,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }));
  }
  const tabs = [{
    id: DECISION_PATH_TABS.CHART,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.explorationResults.decisionPathPlotTab",
      defaultMessage: "Decision plot",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    })
  }, {
    id: DECISION_PATH_TABS.JSON,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.explorationResults.decisionPathJSONTab",
      defaultMessage: "JSON",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDFADecisionPathPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      width: 300
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": `mlDFADecisionPathPopoverTab-${tab.id}`,
    isSelected: tab.id === selectedTabId,
    onClick: () => setSelectedTabId(tab.id),
    key: tab.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, tab.name)))), selectedTabId === DECISION_PATH_TABS.CHART && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    color: "subdued",
    style: {
      paddingTop: 5
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.explorationResults.decisionPathPlotHelpText",
    defaultMessage: "SHAP decision plots use {linkedFeatureImportanceValues} to show how models arrive at the predicted value for ''{predictionFieldName}''.",
    values: {
      predictionFieldName,
      linkedFeatureImportanceValues: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLink,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analytics.explorationResults.linkedFeatureImportanceValues",
        defaultMessage: "feature importance values",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  })), analysisType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION && (0, _mlDataFrameAnalyticsUtils.isClassificationFeatureImportanceBaseline)(baseline) && /*#__PURE__*/_react.default.createElement(_decision_path_classification.ClassificationDecisionPath, {
    featureImportance: featureImportance,
    topClasses: topClasses,
    predictedValue: (0, _use_classification_path_data.getStringBasedClassName)(predictedValue),
    predictedProbability: predictedProbability,
    predictionFieldName: predictionFieldName,
    baseline: baseline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }), analysisType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION && (0, _mlDataFrameAnalyticsUtils.isRegressionFeatureImportanceBaseline)(baseline) && predictedValue !== undefined && /*#__PURE__*/_react.default.createElement(_decision_path_regression.RegressionDecisionPath, {
    featureImportance: featureImportance,
    baseline: baseline,
    predictedValue: typeof predictedValue === 'string' ? parseFloat(predictedValue) : predictedValue,
    predictionFieldName: predictionFieldName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  })), selectedTabId === DECISION_PATH_TABS.JSON && /*#__PURE__*/_react.default.createElement(_decision_path_json_viewer.DecisionPathJSONViewer, {
    featureImportance: featureImportance,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }));
};
exports.DecisionPathPopover = DecisionPathPopover;