"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = exports.progressColumn = exports.getTaskStateBadge = exports.getJobTypeBadge = exports.DFAnalyticsJobIdLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _common = require("./common");
var _use_actions = require("./use_actions");
var _kibana = require("../../../../../contexts/kibana");
var _locator = require("../../../../../../../common/constants/locator");
var _ml_saved_objects_spaces_list = require("../../../../../components/ml_saved_objects_spaces_list");
var _saved_objects = require("../../../../../../../common/types/saved_objects");
var _use_spaces = require("../../../../../hooks/use_spaces");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/analytics_list/use_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TRUNCATE_TEXT_LINES = 3;
var TASK_STATE_COLOR = /*#__PURE__*/function (TASK_STATE_COLOR) {
  TASK_STATE_COLOR["analyzing"] = "primary";
  TASK_STATE_COLOR["failed"] = "danger";
  TASK_STATE_COLOR["reindexing"] = "primary";
  TASK_STATE_COLOR["started"] = "primary";
  TASK_STATE_COLOR["starting"] = "primary";
  TASK_STATE_COLOR["stopped"] = "hollow";
  TASK_STATE_COLOR["stopping"] = "hollow";
  return TASK_STATE_COLOR;
}(TASK_STATE_COLOR || {});
const badgeStyle = {
  maxWidth: '100px'
};
const getTaskStateBadge = (state, failureReason) => {
  const color = TASK_STATE_COLOR[state];
  if ((0, _common.isDataFrameAnalyticsFailed)(state) && failureReason !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: failureReason,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      css: badgeStyle,
      color: color,
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }, state));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: badgeStyle,
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, state);
};
exports.getTaskStateBadge = getTaskStateBadge;
const getJobTypeBadge = jobType => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  css: badgeStyle,
  color: "hollow",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 3
  }
}, jobType);
exports.getJobTypeBadge = getJobTypeBadge;
const progressColumn = exports.progressColumn = {
  name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.progress', {
    defaultMessage: 'Progress'
  }),
  truncateText: true,
  render(item) {
    const {
      currentPhase,
      progress,
      totalPhases
    } = (0, _common.getDataFrameAnalyticsProgressPhase)(item.stats);

    // For now all analytics jobs are batch jobs.
    const isBatchTransform = true;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    }, isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '60px'
      },
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 15
      }
    }, "Phase ", currentPhase, "/", totalPhases)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '40px'
      },
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.progressOfPhase', {
        defaultMessage: 'Progress of phase {currentPhase}: {progress}%',
        values: {
          currentPhase,
          progress
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      value: progress,
      max: 100,
      color: "primary",
      size: "m",
      "data-test-subj": "mlAnalyticsTableProgress",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 17
      }
    })))), !isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '40px'
      },
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }, (0, _common.isDataFrameAnalyticsRunning)(item.stats.state) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      color: "primary",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 17
      }
    }), (0, _common.isDataFrameAnalyticsStopped)(item.stats.state) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      value: 0,
      max: 100,
      color: "primary",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '35px'
      },
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 13
      }
    }, "\xA0")));
  },
  width: '130px',
  'data-test-subj': 'mlAnalyticsTableColumnProgress'
};
const DFAnalyticsJobIdLink = ({
  jobId
}) => {
  const href = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE,
    pageState: {
      jobId
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    css: {
      overflow: 'hidden',
      textOverflow: 'ellipsis'
    },
    title: jobId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  }, jobId);
};
exports.DFAnalyticsJobIdLink = DFAnalyticsJobIdLink;
const useColumns = (expandedRowItemIds, setExpandedRowItemIds, isMlEnabledInSpace = true, refresh = () => {}) => {
  var _application$capabili;
  const {
    services: {
      spaces,
      application
    }
  } = (0, _kibana.useMlKibana)();
  const {
    actions,
    modals
  } = (0, _use_actions.useActions)();
  function toggleDetails(item) {
    const index = expandedRowItemIds.indexOf(item.config.id);
    if (index !== -1) {
      expandedRowItemIds.splice(index, 1);
      setExpandedRowItemIds([...expandedRowItemIds]);
    } else {
      expandedRowItemIds.push(item.config.id);
    }

    // spread to a new array otherwise the component wouldn't re-render
    setExpandedRowItemIds([...expandedRowItemIds]);
  }
  const canManageSpacesAndSavedObjects = (0, _use_spaces.useCanManageSpacesAndSavedObjects)();
  const shouldDisableSpacesColumn = !canManageSpacesAndSavedObjects || !((_application$capabili = application.capabilities.savedObjectsManagement) !== null && _application$capabili !== void 0 && _application$capabili.shareIntoSpace);

  // update possible column types to something like (FieldDataColumn | ComputedColumn | ActionsColumn)[] when they have been added to EUI
  const columns = [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analyticsList.showDetailsColumn.screenReaderDescription",
      defaultMessage: "This column contains clickable controls for showing more details on each job",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 13
      }
    }))),
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleDetails(item),
      "aria-label": expandedRowItemIds.includes(item.config.id) ? _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.rowCollapse', {
        defaultMessage: 'Hide details for {analyticsId}',
        values: {
          analyticsId: item.config.id
        }
      }) : _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.rowExpand', {
        defaultMessage: 'Show details for {analyticsId}',
        values: {
          analyticsId: item.config.id
        }
      }),
      iconType: expandedRowItemIds.includes(item.config.id) ? 'arrowDown' : 'arrowRight',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 9
      }
    }),
    'data-test-subj': 'mlAnalyticsTableRowDetailsToggle'
  }, {
    field: _common.DataFrameAnalyticsListColumn.id,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.id', {
      defaultMessage: 'ID'
    }),
    sortable: item => item.id,
    truncateText: {
      lines: TRUNCATE_TEXT_LINES
    },
    'data-test-subj': 'mlAnalyticsTableColumnId',
    render: id => {
      return /*#__PURE__*/_react.default.createElement("span", {
        title: id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 16
        }
      }, id);
    }
  }, {
    field: _common.DataFrameAnalyticsListColumn.description,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.description', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    truncateText: {
      lines: TRUNCATE_TEXT_LINES
    },
    'data-test-subj': 'mlAnalyticsTableColumnJobDescription',
    render: description => {
      return /*#__PURE__*/_react.default.createElement("span", {
        title: description,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 249,
          columnNumber: 16
        }
      }, description);
    }
  }, {
    field: _common.DataFrameAnalyticsListColumn.memoryStatus,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.memoryStatus', {
      defaultMessage: 'Memory status'
    }),
    truncateText: true,
    'data-test-subj': 'mlAnalyticsTableColumnJobMemoryStatus'
  }, {
    field: _common.DataFrameAnalyticsListColumn.configSourceIndex,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.sourceIndex', {
      defaultMessage: 'Source index'
    }),
    sortable: true,
    truncateText: true,
    'data-test-subj': 'mlAnalyticsTableColumnSourceIndex'
  }, {
    field: _common.DataFrameAnalyticsListColumn.configDestIndex,
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.destinationIndex', {
      defaultMessage: 'Destination index'
    }),
    sortable: true,
    truncateText: true,
    'data-test-subj': 'mlAnalyticsTableColumnDestIndex'
  }, {
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.type', {
      defaultMessage: 'Type'
    }),
    sortable: item => (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(item.config.analysis),
    truncateText: true,
    render(item) {
      return getJobTypeBadge((0, _mlDataFrameAnalyticsUtils.getAnalysisType)(item.config.analysis));
    },
    width: '150px',
    'data-test-subj': 'mlAnalyticsTableColumnType'
  }, {
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.status', {
      defaultMessage: 'Status'
    }),
    sortable: item => item.stats.state,
    truncateText: true,
    render(item) {
      return getTaskStateBadge(item.stats.state, item.stats.failure_reason);
    },
    width: '100px',
    'data-test-subj': 'mlAnalyticsTableColumnStatus'
  }, progressColumn, ...(canManageSpacesAndSavedObjects && spaces ? [{
    name: _i18n.i18n.translate('xpack.ml.jobsList.jobActionsColumn.spaces', {
      defaultMessage: 'Spaces'
    }),
    'data-test-subj': 'mlTableColumnSpaces',
    truncateText: true,
    align: 'right',
    width: '10%',
    disabled: shouldDisableSpacesColumn,
    render: item => {
      return /*#__PURE__*/_react.default.createElement(_ml_saved_objects_spaces_list.MLSavedObjectsSpacesList, {
        disabled: shouldDisableSpacesColumn,
        spacesApi: spaces,
        spaceIds: item.spaces,
        id: item.id,
        mlSavedObjectType: _saved_objects.DFA_SAVED_OBJECT_TYPE,
        refresh: refresh,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 312,
          columnNumber: 17
        }
      });
    }
  }] : []), {
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.tableActionLabel', {
      defaultMessage: 'Actions'
    }),
    actions,
    width: '150px',
    'data-test-subj': 'mlAnalyticsTableColumnActions'
  }];
  return {
    columns,
    modals
  };
};
exports.useColumns = useColumns;