"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceSelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlNestedProperty = require("@kbn/ml-nested-property");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _create_data_view_button = require("../../../../../components/create_data_view_button");
var _kibana = require("../../../../../contexts/kibana");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _locator = require("../../../../../../../common/constants/locator");
var _index_utils = require("../../../../../util/index_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/source_selection/source_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fixedPageSize = 20;
const SourceSelection = () => {
  const {
    services: {
      savedSearch: savedSearchService,
      data: {
        dataViews: dataViewsService
      },
      contentManagement,
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const mlManagementLocator = (0, _kibana.useMlManagementLocator)();
  const [isCcsCallOut, setIsCcsCallOut] = (0, _react.useState)(false);
  const [ccsCallOutBodyText, setCcsCallOutBodyText] = (0, _react.useState)();
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const onSearchSelected = async (id, type, fullName, savedObject) => {
    // Kibana data views including `:` are cross-cluster search indices
    // and are not supported by Data Frame Analytics yet. For saved searches
    // and data views that use cross-cluster search we intercept
    // the selection before redirecting and show an error callout instead.
    let dataViewName = '';
    if (type === 'index-pattern' && savedObject) {
      dataViewName = (0, _mlNestedProperty.getNestedProperty)(savedObject, 'attributes.title');
    } else if (type === 'search') {
      try {
        var _dataViewAndSavedSear, _dataViewAndSavedSear2;
        const dataViewAndSavedSearch = await (0, _index_utils.getDataViewAndSavedSearchCallback)({
          savedSearchService,
          dataViewsService
        })(id);
        dataViewName = (_dataViewAndSavedSear = (_dataViewAndSavedSear2 = dataViewAndSavedSearch.dataView) === null || _dataViewAndSavedSear2 === void 0 ? void 0 : _dataViewAndSavedSear2.title) !== null && _dataViewAndSavedSear !== void 0 ? _dataViewAndSavedSear : '';
      } catch (error) {
        // an unexpected error has occurred. This could be caused by a saved search for which the data view no longer exists.
        toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.errorGettingDataViewTitle', {
          defaultMessage: 'Error loading data view used by the saved Discover session'
        }));
        return;
      }
    }
    if ((0, _index_utils.isCcsIndexPattern)(dataViewName) && savedObject) {
      setIsCcsCallOut(true);
      if (type === 'search') {
        setCcsCallOutBodyText(_i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.CcsErrorCallOutBody', {
          defaultMessage: `The saved Discover session ''{savedSearchTitle}'' uses the data view ''{dataViewName}''.`,
          values: {
            savedSearchTitle: (0, _mlNestedProperty.getNestedProperty)(savedObject, 'attributes.title'),
            dataViewName
          }
        }));
      } else {
        setCcsCallOutBodyText(undefined);
      }
      return;
    }
    await (mlManagementLocator === null || mlManagementLocator === void 0 ? void 0 : mlManagementLocator.navigate({
      sectionId: 'ml',
      appId: `analytics/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB}?${type === 'index-pattern' ? 'index' : 'savedSearchId'}=${encodeURIComponent(id)}`
    }));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDFAPageSourceSelection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, isCcsCallOut && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "analyticsCreateSourceIndexModalCcsErrorCallOut",
    title: _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.CcsErrorCallOutTitle', {
      defaultMessage: 'Data views using cross-cluster search are not supported.'
    }),
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, typeof ccsCallOutBodyText === 'string' && /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 60
    }
  }, ccsCallOutBodyText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "mlDFASourceSelection",
    key: "searchSavedObjectFinder",
    onChoose: onSearchSelected,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.notFoundLabel', {
      defaultMessage: 'No matching indices or saved Discover sessions found.'
    }),
    savedObjectMetaData: [{
      type: 'search',
      getIconForSavedObject: () => 'discoverApp',
      name: _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.savedObjectType.discoverSession', {
        defaultMessage: 'Discover session'
      }),
      showSavedObject: savedObject =>
      // ES|QL Based saved searches are not supported in DFA, filter them out
      savedObject.attributes.isTextBasedQuery !== true
    }, {
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      })
    }],
    fixedPageSize: fixedPageSize,
    services: {
      contentClient: contentManagement.client,
      uiSettings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_create_data_view_button.CreateDataViewButton, {
    onDataViewCreated: dataView => {
      onSearchSelected(dataView.id, 'index-pattern', dataView.getIndexPattern());
    },
    allowAdHocDataView: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  })))));
};
exports.SourceSelection = SourceSelection;