"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyTimeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _public = require("@kbn/presentation-util-plugin/public");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _anomaly_swimlane_embeddable = require("../../embeddables/anomaly_swimlane/anomaly_swimlane_embeddable");
var _use_cases_modal = require("../contexts/kibana/use_cases_modal");
var _ = require("../..");
var _explorer_constants = require("./explorer_constants");
var _kibana = require("../contexts/kibana");
var _explorer_no_influencers_found = require("./components/explorer_no_influencers_found");
var _swimlane_container = require("./swimlane_container");
var _no_overall_data = require("./components/no_overall_data");
var _severity_legend_control = require("./components/severity_legend_control/severity_legend_control");
var _anomaly_timeline_help_popover = require("./anomaly_timeline_help_popover");
var _chart_tooltip = require("../components/chart_tooltip");
var _swimlane_annotation_container = require("./swimlane_annotation_container");
var _anomaly_timeline_service = require("../services/anomaly_timeline_service");
var _anomaly_explorer_context = require("./anomaly_explorer_context");
var _use_selected_cells = require("./hooks/use_selected_cells");
var _alerts = require("./alerts");
var _constants = require("./constants");
var _constants2 = require("../../cases/constants");
var _use_job_selection = require("./hooks/use_job_selection");
var _use_severity_options = require("./hooks/use_severity_options");
var _use_threshold_to_severity = require("./hooks/use_threshold_to_severity");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/anomaly_timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function mapSwimlaneOptionsToEuiOptions(options) {
  return options.map(option => ({
    value: option,
    text: option
  }));
}
const SavedObjectSaveModalDashboard = (0, _public.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
function getDefaultEmbeddablePanelConfig(jobIds, queryString) {
  return {
    title: (0, _anomaly_swimlane_embeddable.getDefaultSwimlanePanelTitle)(jobIds).concat(queryString ? `- ${queryString}` : ''),
    id: (0, _eui.htmlIdGenerator)()()
  };
}
const AnomalyTimeline = exports.AnomalyTimeline = /*#__PURE__*/_react.default.memo(({
  explorerState
}) => {
  var _capabilities$dashboa, _capabilities$dashboa2, _selectedJobs$length;
  const {
    services: {
      application: {
        capabilities
      },
      charts: chartsService,
      cases,
      embeddable,
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const globalTimeRange = (0, _mlDatePicker.useTimeRangeUpdates)(true);
  const selectCaseModal = cases === null || cases === void 0 ? void 0 : cases.hooks.useCasesAddToExistingCaseModal();
  const {
    anomalyExplorerCommonStateService,
    anomalyTimelineStateService,
    annotationsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const setSelectedCells = anomalyTimelineStateService.setSelectedCells.bind(anomalyTimelineStateService);
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const canEditDashboards = (_capabilities$dashboa = (_capabilities$dashboa2 = capabilities.dashboard_v2) === null || _capabilities$dashboa2 === void 0 ? void 0 : _capabilities$dashboa2.createNew) !== null && _capabilities$dashboa !== void 0 ? _capabilities$dashboa : false;
  const timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const overallAnnotations = (0, _useObservable.default)(annotationsStateService.overallAnnotations$, annotationsStateService.overallAnnotations);
  const {
    filterActive,
    queryString
  } = (0, _useObservable.default)(anomalyExplorerCommonStateService.filterSettings$, anomalyExplorerCommonStateService.filterSettings);
  const swimlaneLimit = (0, _useObservable.default)(anomalyTimelineStateService.getSwimLaneCardinality$());
  const {
    selectedJobs,
    mergedGroupsAndJobsIds
  } = (0, _use_job_selection.useJobSelection)();
  const loading = (0, _useObservable.default)(anomalyTimelineStateService.isOverallSwimLaneLoading$(), true);
  const swimlaneContainerWidth = (0, _useObservable.default)(anomalyTimelineStateService.getContainerWidth$(), anomalyTimelineStateService.getContainerWidth());
  const viewBySwimlaneDataLoading = (0, _useObservable.default)(anomalyTimelineStateService.isViewBySwimLaneLoading$(), true);
  const overallSwimlaneData = (0, _useObservable.default)(anomalyTimelineStateService.getOverallSwimLaneData$());
  const viewBySwimlaneData = (0, _useObservable.default)(anomalyTimelineStateService.getViewBySwimLaneData$());
  const selectedCells = (0, _useObservable.default)(anomalyTimelineStateService.getSelectedCells$(), anomalyTimelineStateService.getSelectedCells());
  const swimLaneSeverity = (0, _useObservable.default)(anomalyTimelineStateService.getSwimLaneSeverity$());
  const severityOptions = (0, _use_severity_options.useSeverityOptions)();
  const thresholdToSeverity = (0, _use_threshold_to_severity.useThresholdToSeverity)();
  const [localSeverityOptions, setLocalSeverityOptions] = (0, _react.useState)(null);
  (0, _useDebounce.default)(() => {
    if (localSeverityOptions) {
      const thresholds = localSeverityOptions.map(severity => severity.threshold);
      anomalyTimelineStateService.setSeverity(thresholds);
    }
  }, 500, [localSeverityOptions]);

  // Use URL state on initial load, then local state for UI updates
  const selectedSeverityOptions = (0, _react.useMemo)(() => {
    if (localSeverityOptions) {
      return localSeverityOptions;
    }
    if (!(swimLaneSeverity !== null && swimLaneSeverity !== void 0 && swimLaneSeverity.length)) {
      return severityOptions;
    }
    return thresholdToSeverity(swimLaneSeverity);
  }, [localSeverityOptions, swimLaneSeverity, severityOptions, thresholdToSeverity]);
  const handleSeverityChange = (0, _react.useCallback)(newSelectedSeverities => {
    setLocalSeverityOptions(newSelectedSeverities);
  }, []);
  const viewBySwimlaneFieldName = (0, _useObservable.default)(anomalyTimelineStateService.getViewBySwimlaneFieldName$());
  const viewBySwimlaneOptions = (0, _useObservable.default)(anomalyTimelineStateService.getViewBySwimLaneOptions$(), anomalyTimelineStateService.getViewBySwimLaneOptions());
  const {
    viewByPerPage,
    viewByFromPage
  } = (0, _useObservable.default)(anomalyTimelineStateService.getSwimLanePagination$(), anomalyTimelineStateService.getSwimLanePagination());
  const [selectedSwimlane, setSelectedSwimlane] = (0, _react.useState)();
  const timeRange = (0, _use_selected_cells.getTimeBoundsFromSelection)(selectedCells);
  const viewByLoadedForTimeFormatted = timeRange ? `${(0, _mlDateUtils.formatHumanReadableDateTime)(timeRange.earliestMs)} - ${(0, _mlDateUtils.formatHumanReadableDateTime)(timeRange.latestMs)}` : null;
  const openCasesModalCallback = (0, _use_cases_modal.useCasesModal)(_.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE, _constants2.CASES_TOAST_MESSAGES_TITLES.ANOMALY_TIMELINE);
  const openCasesModal = (0, _react.useCallback)(swimLaneType => {
    openCasesModalCallback({
      swimlaneType: swimLaneType,
      ...(swimLaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY ? {
        viewBy: viewBySwimlaneFieldName
      } : {}),
      // For cases attachment, pass just the job IDs to maintain stale data
      jobIds: selectedJobs === null || selectedJobs === void 0 ? void 0 : selectedJobs.map(v => v.id),
      timeRange: globalTimeRange,
      ...((0, _mlIsDefined.isDefined)(queryString) && queryString !== '' ? {
        query: {
          query: queryString,
          language: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY
        }
      } : {})
    });
  }, [openCasesModalCallback, selectedJobs, globalTimeRange, viewBySwimlaneFieldName, queryString]);
  const annotations = (0, _react.useMemo)(() => overallAnnotations.annotationsData, [overallAnnotations]);
  const closePopoverOnAction = (0, _react.useCallback)(actionCallback => {
    return () => {
      setIsMenuOpen(false);
      actionCallback();
    };
  }, [setIsMenuOpen]);
  const menuPanels = (0, _react.useMemo)(() => {
    const rootItems = [];
    const panels = [{
      id: 0,
      items: rootItems
    }];
    if (canEditDashboards) {
      rootItems.push({
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.explorer.addToDashboardLabel",
          defaultMessage: "Add to dashboard",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 270,
            columnNumber: 13
          }
        }),
        panel: 'addToDashboardPanel',
        icon: 'dashboardApp',
        'data-test-subj': 'mlAnomalyTimelinePanelAddToDashboardButton'
      });
      panels.push({
        id: 'addToDashboardPanel',
        size: 's',
        title: _i18n.i18n.translate('xpack.ml.explorer.addToDashboardLabel', {
          defaultMessage: 'Add to dashboard'
        }),
        items: [{
          name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.explorer.overallLabel",
            defaultMessage: "Overall",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 289,
              columnNumber: 17
            }
          }),
          onClick: closePopoverOnAction(setSelectedSwimlane.bind(null, _explorer_constants.SWIMLANE_TYPE.OVERALL)),
          'data-test-subj': 'mlAnomalyTimelinePanelAddOverallToDashboardButton'
        }, {
          name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.explorer.viewByFieldLabel",
            defaultMessage: "View by {viewByField}",
            values: {
              viewByField: viewBySwimlaneFieldName
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 297,
              columnNumber: 17
            }
          }),
          onClick: closePopoverOnAction(setSelectedSwimlane.bind(null, _explorer_constants.SWIMLANE_TYPE.VIEW_BY)),
          'data-test-subj': 'mlAnomalyTimelinePanelAddViewByToDashboardButton'
        }]
      });
    }
    const casesPrivileges = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases();
    if ((!!(casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.create) || !!(casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.update)) && selectCaseModal) {
      rootItems.push({
        panel: 1,
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.explorer.attachToCaseLabel",
          defaultMessage: "Add to case",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 317,
            columnNumber: 13
          }
        }),
        icon: 'casesApp',
        'data-test-subj': 'mlAnomalyTimelinePanelAttachToCaseButton'
      });
      panels.push({
        id: 1,
        initialFocusedItemIndex: 0,
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.explorer.attachToCaseLabel",
          defaultMessage: "Add to case",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 330,
            columnNumber: 13
          }
        }),
        items: [{
          name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.explorer.attachOverallSwimLane",
            defaultMessage: "Overall",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 338,
              columnNumber: 17
            }
          }),
          onClick: closePopoverOnAction(openCasesModal.bind(null, _explorer_constants.SWIMLANE_TYPE.OVERALL)),
          'data-test-subj': 'mlAnomalyTimelinePanelAttachOverallButton'
        }, {
          name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.explorer.attachViewBySwimLane",
            defaultMessage: "View by {viewByField}",
            values: {
              viewByField: viewBySwimlaneFieldName
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 348,
              columnNumber: 17
            }
          }),
          onClick: closePopoverOnAction(openCasesModal.bind(null, _explorer_constants.SWIMLANE_TYPE.VIEW_BY)),
          'data-test-subj': 'mlAnomalyTimelinePanelAttachViewByButton'
        }]
      });
    }
    return panels;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [canEditDashboards, openCasesModal, viewBySwimlaneFieldName]);

  // If selecting a cell in the 'view by' swimlane, indicate the corresponding time in the Overall swimlane.
  const overallCellSelection = (0, _react.useMemo)(() => {
    if (!selectedCells) return;
    if (selectedCells.type === _explorer_constants.SWIMLANE_TYPE.OVERALL) return selectedCells;
    return {
      type: _explorer_constants.SWIMLANE_TYPE.OVERALL,
      lanes: [_explorer_constants.OVERALL_LABEL],
      times: selectedCells.times
    };
  }, [selectedCells]);
  const annotationXDomain = (0, _react.useMemo)(() => _anomaly_timeline_service.AnomalyTimelineService.isOverallSwimlaneData(overallSwimlaneData) ? {
    min: overallSwimlaneData.earliest * 1000,
    max: overallSwimlaneData.latest * 1000,
    minInterval: overallSwimlaneData.interval * 1000
  } : undefined, [overallSwimlaneData]);
  const onResize = (0, _react.useCallback)(value => {
    anomalyTimelineStateService.setContainerWidth(value);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onSaveCallback = (0, _react.useCallback)(async ({
    dashboardId,
    newTitle,
    newDescription
  }) => {
    if (!selectedJobs) return;
    const stateTransfer = embeddable.getStateTransfer();
    const config = getDefaultEmbeddablePanelConfig(mergedGroupsAndJobsIds, queryString);
    const embeddableInput = {
      id: config.id,
      title: newTitle,
      description: newDescription,
      jobIds: mergedGroupsAndJobsIds,
      swimlaneType: selectedSwimlane,
      ...(selectedSwimlane === _explorer_constants.SWIMLANE_TYPE.VIEW_BY ? {
        viewBy: viewBySwimlaneFieldName
      } : {}),
      ...(queryString !== undefined ? {
        query: {
          query: queryString,
          language: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY
        }
      } : {})
    };
    const state = {
      serializedState: {
        rawState: embeddableInput,
        references: []
      },
      type: _.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [embeddable, mergedGroupsAndJobsIds, queryString, selectedJobs, selectedSwimlane, viewBySwimlaneFieldName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    responsive: false,
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 444,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.anomalyTimelineTitle",
    defaultMessage: "Anomaly timeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_timeline_help_popover.AnomalyTimelineHelpPopover, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 15
    }
  })), menuPanels[0].items.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginLeft: 'auto !important',
      alignSelf: 'baseline'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      "aria-label": _i18n.i18n.translate('xpack.ml.explorer.swimlaneActions', {
        defaultMessage: 'Actions'
      }),
      color: "text",
      display: "base",
      isSelected: isMenuOpen,
      iconType: "boxesHorizontal",
      onClick: setIsMenuOpen.bind(null, !isMenuOpen),
      "data-test-subj": "mlAnomalyTimelinePanelMenu",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 467,
        columnNumber: 21
      }
    }),
    isOpen: isMenuOpen,
    closePopover: setIsMenuOpen.bind(null, false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: menuPanels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 19
    }
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 491,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "baseline",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 493,
      columnNumber: 11
    }
  }, viewBySwimlaneOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    prepend: _i18n.i18n.translate('xpack.ml.explorer.viewByLabel', {
      defaultMessage: 'View by'
    }),
    compressed: true,
    id: "selectViewBy",
    options: mapSwimlaneOptionsToEuiOptions(viewBySwimlaneOptions),
    value: viewBySwimlaneFieldName,
    onChange: e => {
      anomalyTimelineStateService.setViewBySwimLaneFieldName(e.target.value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 497,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '280px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 513,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_severity_legend_control.SeverityLegendControl, {
    allSeverityOptions: severityOptions,
    selectedSeverities: selectedSeverityOptions,
    onChange: handleSeverityChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 514,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 522,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 524,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    color: 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 526,
      columnNumber: 15
    }
  }, viewByLoadedForTimeFormatted && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.sortedByMaxAnomalyScoreForTimeFormattedLabel",
    defaultMessage: "(Sorted by max anomaly score for {viewByLoadedForTimeFormatted})",
    values: {
      viewByLoadedForTimeFormatted
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 19
    }
  }), (0, _mlIsDefined.isDefined)(viewByLoadedForTimeFormatted) ? null : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.sortedByMaxAnomalyScoreLabel",
    defaultMessage: "(Sorted by max anomaly score)",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 535,
      columnNumber: 19
    }
  }), filterActive === true && viewBySwimlaneFieldName === _explorer_constants.VIEW_BY_JOB_LABEL && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.jobScoreAcrossAllInfluencersLabel",
    defaultMessage: "(Job score across all influencers)",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 541,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      visibility: selectedCells ? 'visible' : 'hidden'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: setSelectedCells.bind(anomalyTimelineStateService, undefined),
    "data-test-subj": "mlAnomalyTimelineClearSelection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 549,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.clearSelectionLabel",
    defaultMessage: "Clear selection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 554,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 562,
      columnNumber: 11
    }
  }), annotationXDomain && Array.isArray(annotations) && annotations.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 566,
      columnNumber: 15
    }
  }, tooltipService => /*#__PURE__*/_react.default.createElement(_swimlane_annotation_container.SwimlaneAnnotationContainer, {
    chartWidth: swimlaneContainerWidth,
    domain: annotationXDomain,
    annotationsData: annotations,
    tooltipService: tooltipService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 568,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 576,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_alerts.SwimLaneWrapper, {
    selection: overallCellSelection,
    swimlaneContainerWidth: swimlaneContainerWidth,
    swimLaneData: overallSwimlaneData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_swimlane_container.SwimlaneContainer, {
    id: "overall",
    "data-test-subj": "mlAnomalyExplorerSwimlaneOverall",
    filterActive: filterActive,
    timeBuckets: timeBuckets,
    swimlaneData: overallSwimlaneData,
    swimlaneType: _explorer_constants.SWIMLANE_TYPE.OVERALL,
    selection: overallCellSelection,
    onCellsSelection: setSelectedCells,
    onResize: onResize,
    isLoading: loading,
    noDataWarning: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: 'center',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 597,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 598,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_no_overall_data.NoOverallData, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 599,
        columnNumber: 21
      }
    }))),
    showTimeline: false,
    showLegend: false,
    yAxisWidth: _constants.Y_AXIS_LABEL_WIDTH,
    chartsService: chartsService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 585,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 610,
      columnNumber: 11
    }
  }), viewBySwimlaneOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_swimlane_container.SwimlaneContainer, {
    id: "view_by",
    "data-test-subj": "mlAnomalyExplorerSwimlaneViewBy",
    filterActive: filterActive,
    timeBuckets: timeBuckets,
    showLegend: false,
    swimlaneData: viewBySwimlaneData,
    swimlaneType: _explorer_constants.SWIMLANE_TYPE.VIEW_BY,
    selection: selectedCells,
    onCellsSelection: setSelectedCells,
    onResize: onResize,
    fromPage: viewByFromPage,
    perPage: viewByPerPage,
    swimlaneLimit: swimlaneLimit,
    chartsService: chartsService,
    onPaginationChange: ({
      perPage: perPageUpdate,
      fromPage: fromPageUpdate
    }) => {
      if (perPageUpdate) {
        anomalyTimelineStateService.setSwimLanePagination({
          viewByPerPage: perPageUpdate
        });
      }
      if (fromPageUpdate) {
        anomalyTimelineStateService.setSwimLanePagination({
          viewByFromPage: fromPageUpdate
        });
      }
    },
    isLoading: loading || viewBySwimlaneDataLoading,
    yAxisWidth: _constants.Y_AXIS_LABEL_WIDTH,
    noDataWarning: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: 'center',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 642,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 643,
        columnNumber: 19
      }
    }, typeof viewBySwimlaneFieldName === 'string' ? viewBySwimlaneFieldName === _explorer_constants.VIEW_BY_JOB_LABEL ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.noResultForSelectedJobsMessage",
      defaultMessage: "No results found for selected {jobsCount, plural, one {job} other {jobs}}",
      values: {
        jobsCount: (_selectedJobs$length = selectedJobs === null || selectedJobs === void 0 ? void 0 : selectedJobs.length) !== null && _selectedJobs$length !== void 0 ? _selectedJobs$length : 1
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 646,
        columnNumber: 25
      }
    }) : /*#__PURE__*/_react.default.createElement(_explorer_no_influencers_found.ExplorerNoInfluencersFound, {
      viewBySwimlaneFieldName: viewBySwimlaneFieldName,
      showFilterMessage: filterActive === true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 652,
        columnNumber: 25
      }
    }) : null)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 612,
      columnNumber: 13
    }
  })), selectedSwimlane && selectedJobs ? /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboard, {
    canSaveByReference: false,
    objectType: _i18n.i18n.translate('xpack.ml.cases.anomalySwimLane.displayName', {
      defaultMessage: 'Anomaly swim lane'
    }),
    documentInfo: {
      title: (0, _anomaly_swimlane_embeddable.getDefaultSwimlanePanelTitle)(mergedGroupsAndJobsIds)
    },
    onClose: () => {
      setSelectedSwimlane(undefined);
    },
    onSave: onSaveCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 665,
      columnNumber: 11
    }
  }) : null);
}, (prevProps, nextProps) => {
  return (0, _lodash.isEqual)(prevProps.explorerState, nextProps.explorerState);
});