"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _entity_filter_styles = require("./entity_filter_styles");
var _component_utils = require("../../../../../util/component_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer_charts/components/explorer_chart_label/entity_filter/entity_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EntityFilter = ({
  onFilter,
  influencerFieldName,
  influencerFieldValue,
  isEmbeddable
}) => {
  const {
    filterButton
  } = (0, _entity_filter_styles.useEntityFilterStyles)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.entityFilter.addFilterTooltip",
      defaultMessage: "Filter for",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    css: filterButton,
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      onFilter({
        influencerFieldName,
        influencerFieldValue,
        action: _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.ADD
      });
    }),
    iconType: "plusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.ml.entityFilter.addFilterAriaLabel', {
      defaultMessage: 'Add filter for {influencerFieldName} {influencerFieldValue}',
      values: {
        influencerFieldName,
        influencerFieldValue
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isEmbeddable ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.entityFilter.filterOutTooltip",
      defaultMessage: 'Filter out',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.entityFilter.removeFilterTooltip",
      defaultMessage: 'Remove filter',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    css: filterButton,
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      onFilter({
        influencerFieldName,
        influencerFieldValue,
        action: _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.REMOVE
      });
    }),
    iconType: "minusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.ml.entityFilter.removeFilterAriaLabel', {
      defaultMessage: 'Remove filter for {influencerFieldName} {influencerFieldValue}',
      values: {
        influencerFieldName,
        influencerFieldValue
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  })));
};
exports.EntityFilter = EntityFilter;