"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelBounds = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _settings = require("../common/settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/charts/anomaly_chart/model_bounds.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SPEC_ID = 'model';
const style = {
  ..._settings.areaSeriesStyle,
  area: {
    ..._settings.areaSeriesStyle.area,
    visible: true
  },
  line: {
    ..._settings.areaSeriesStyle.line,
    strokeWidth: 1,
    opacity: 0.4
  }
};
const ModelBounds = ({
  modelData
}) => {
  const {
    MODEL_COLOR
  } = (0, _settings.useChartColors)();
  const model = modelData === undefined ? [] : modelData;
  return /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: SPEC_ID
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'time',
    yAccessors: ['modelUpper'],
    y0Accessors: ['modelLower'],
    data: model,
    curve: _charts.CurveType.CURVE_MONOTONE_X,
    areaSeriesStyle: style,
    color: MODEL_COLOR,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
};
exports.ModelBounds = ModelBounds;