"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ByFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _split_field_select = require("../split_field_select");
var _job_creator_context = require("../../../job_creator_context");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/by_field/by_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ByFieldSelector = ({
  detectorIndex
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const newJobCapsService = (0, _new_job_capabilities_service.useNewJobCapsService)();
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'byFieldSelector'
  });

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const runtimeCategoryFields = (0, _react.useMemo)(() => (0, _fields_utils.filterCategoryFields)(jobCreator.runtimeFields), []);
  const allCategoryFields = (0, _react.useMemo)(() => [...newJobCapsService.categoryFields, ...runtimeCategoryFields].sort((a, b) => a.name.localeCompare(b.name)),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const [byField, setByField] = (0, _react.useState)(jobCreator.getByField(detectorIndex));
  const categoryFields = useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated);
  (0, _react.useEffect)(() => {
    jobCreator.setByField(byField, detectorIndex);
    // add the by field to the influencers
    if (byField !== null && jobCreator.influencers.includes(byField.name) === false) {
      jobCreator.addInfluencer(byField.name);
    }
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [byField]);
  (0, _react.useEffect)(() => {
    const bf = jobCreator.getByField(detectorIndex);
    setByField(bf);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_split_field_select.SplitFieldSelect, {
    fields: categoryFields,
    changeHandler: setByField,
    selectedField: byField,
    isClearable: true,
    testSubject: "mlByFieldSelect",
    placeholder: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.populationField.placeholder', {
      defaultMessage: 'Split data'
    }),
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  });
};

// remove the population (over) field from the by field options
exports.ByFieldSelector = ByFieldSelector;
function useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated) {
  const [fields, setFields] = (0, _react.useState)(allCategoryFields);
  (0, _react.useEffect)(() => {
    const pf = jobCreator.populationField;
    if (pf !== null) {
      setFields(allCategoryFields.filter(({
        name
      }) => name !== pf.name));
    } else {
      setFields(allCategoryFields);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return fields;
}