"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wizard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _model_memory_estimator = require("../../common/job_creator/util/model_memory_estimator");
var _step_types = require("../components/step_types");
var _job_creator_context = require("../components/job_creator_context");
var _new_job_capabilities_service = require("../../../../services/new_job_capabilities/new_job_capabilities_service");
var _wizard_steps = require("./wizard_steps");
var _wizard_horizontal_steps = require("./wizard_horizontal_steps");
var _new_job = require("../../../../../../common/constants/new_job");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/new_job/wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Wizard = ({
  jobCreator,
  chartLoader,
  mapLoader,
  resultsLoader,
  chartInterval,
  jobValidator,
  existingJobsAndGroups,
  firstWizardStep = _step_types.WIZARD_STEPS.TIME_RANGE
}) => {
  const newJobCapsService = (0, _new_job_capabilities_service.useNewJobCapsService)();
  const [jobCreatorUpdated, setJobCreatorUpdate] = (0, _react.useState)(0);
  const jobCreatorUpdate = (0, _react.useCallback)(() => {
    setJobCreatorUpdate(prev => prev + 1);
  }, []);
  const [jobValidatorUpdated, setJobValidatorUpdate] = (0, _react.useState)(0);
  const jobValidatorUpdate = (0, _react.useCallback)(() => {
    setJobValidatorUpdate(prev => prev + 1);
  }, []);
  const jobCreatorContext = {
    jobCreatorUpdated,
    jobCreatorUpdate,
    jobCreator,
    chartLoader,
    mapLoader,
    resultsLoader,
    chartInterval,
    jobValidator,
    jobValidatorUpdated,
    fields: newJobCapsService.fields,
    aggs: newJobCapsService.aggs,
    existingJobsAndGroups
  };
  const firstStep = jobCreator.type === _new_job.JOB_TYPE.ADVANCED ? _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED : _step_types.WIZARD_STEPS.TIME_RANGE;
  const [currentStep, setCurrentStep] = (0, _react.useState)(firstStep);
  const [highestStep, setHighestStep] = (0, _react.useState)(firstStep);
  const [disableSteps, setDisableSteps] = (0, _react.useState)(false);
  const [progress, setProgress] = (0, _react.useState)(resultsLoader.progress);
  const [stringifiedConfigs, setStringifiedConfigs] = (0, _react.useState)(stringifyConfigs(jobCreator.jobConfig, jobCreator.datafeedConfig));
  (0, _react.useEffect)(() => {
    const subscription = jobValidator.validationResult$.subscribe(() => {
      jobValidatorUpdate();
    });
    return () => {
      return subscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidator]);
  (0, _react.useEffect)(() => {
    jobValidator.validate(() => {
      jobValidatorUpdate();
    });

    // if the job config has changed, reset the highestStep
    // compare a stringified config to ensure the configs have actually changed
    const tempConfigs = stringifyConfigs(jobCreator.jobConfig, jobCreator.datafeedConfig);
    if (tempConfigs !== stringifiedConfigs) {
      setHighestStep(currentStep);
      setStringifiedConfigs(tempConfigs);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    jobCreator.subscribeToProgress(setProgress);
    setCurrentStep(firstWizardStep);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // disable the step links if the job is running
  (0, _react.useEffect)(() => {
    setDisableSteps(progress > 0);
  }, [progress]);

  // keep a record of the highest step reached in the wizard
  (0, _react.useEffect)(() => {
    if (currentStep >= highestStep) {
      setHighestStep(currentStep);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentStep]);
  (0, _model_memory_estimator.useModelMemoryEstimator)(jobCreator, jobValidator, jobCreatorUpdate, jobCreatorUpdated);
  return /*#__PURE__*/_react.default.createElement(_job_creator_context.JobCreatorContext.Provider, {
    value: jobCreatorContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_wizard_horizontal_steps.WizardHorizontalSteps, {
    currentStep: currentStep,
    highestStep: highestStep,
    setCurrentStep: setCurrentStep,
    disableSteps: disableSteps,
    jobType: jobCreator.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_wizard_steps.WizardSteps, {
    currentStep: currentStep,
    setCurrentStep: setCurrentStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }));
};
exports.Wizard = Wizard;
function stringifyConfigs(jobConfig, datafeedConfig) {
  return JSON.stringify(jobConfig) + JSON.stringify(datafeedConfig);
}