"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSettingsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlValidators = require("@kbn/ml-validators");
var _data_source_context = require("../../../../contexts/ml/data_source_context");
var _page = require("../page");
var _components = require("../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/recognize/components/job_settings_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobSettingsForm = ({
  onSubmit,
  onJobPrefixChange,
  saveState,
  jobs
}) => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const {
    from,
    to
  } = (0, _mlDatePicker.getTimeFilterRange)(timefilter);
  const {
    selectedDataView: dataView
  } = (0, _data_source_context.useDataSource)();
  const jobPrefixValidator = (0, _react.useMemo)(() => (0, _mlValidators.composeValidators)((0, _mlValidators.patternValidator)(/^([a-z0-9]+[a-z0-9\-_]*)?$/), (0, _mlValidators.maxLengthValidator)(_mlValidators.JOB_ID_MAX_LENGTH - Math.max(...jobs.map(({
    id
  }) => id.length)))), [jobs]);
  const [jobPrefix, setJobPrefix] = (0, _react.useState)('');
  const [startDatafeedAfterSave, setStartDatafeedAfterSave] = (0, _react.useState)(true);
  const [useFullIndexData, setUseFullIndexData] = (0, _react.useState)(true);
  const [timeRange, setTimeRange] = (0, _react.useState)({
    start: from,
    end: to
  });
  const [useDedicatedIndex, setUseDedicatedIndex] = (0, _react.useState)(false);
  const [validationResult, setValidationResult] = (0, _react.useState)({});
  const createJobSettings = () => {
    return {
      jobPrefix,
      startDatafeedAfterSave,
      useFullIndexData,
      timeRange,
      useDedicatedIndex
    };
  };
  const handleValidation = (0, _react.useCallback)(() => {
    const jobPrefixValidationResult = jobPrefixValidator(jobPrefix);
    setValidationResult({
      jobPrefix: jobPrefixValidationResult,
      formValid: !jobPrefixValidationResult
    });
  }, [jobPrefix, jobPrefixValidator]);
  (0, _react.useEffect)(() => {
    handleValidation();
    onJobPrefixChange(jobPrefix);
  }, [handleValidation, jobPrefix, onJobPrefixChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobIdPrefixLabel",
      defaultMessage: "Job ID prefix",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.tooltips.newJobRecognizerJobPrefixTooltip",
      defaultMessage: "The prefix is added to the beginning of each job ID.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobIdPrefixLabel",
      defaultMessage: "Job ID prefix",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 15
      }
    }),
    isInvalid: !!validationResult.jobPrefix,
    error: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, validationResult.jobPrefix && validationResult.jobPrefix.maxLength ? /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobPrefixInvalidMaxLengthErrorMessage",
      defaultMessage: "Job ID prefix must be no more than {maxLength, plural, one {# character} other {# characters}} long.",
      values: {
        maxLength: validationResult.jobPrefix.maxLength.requiredLength
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 21
      }
    })) : null, validationResult.jobPrefix && validationResult.jobPrefix.pattern && /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobLabelAllowedCharactersDescription",
      defaultMessage: "Job label can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with an alphanumeric character",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 21
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "jobPrefix",
    value: jobPrefix,
    onChange: ({
      target: {
        value
      }
    }) => setJobPrefix(value),
    isInvalid: !!validationResult.jobPrefix,
    "data-test-subj": "mlJobRecognizerWizardInputJobIdPrefix",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "startDataFeed",
    name: "startDataFeed",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.startDatafeedAfterSaveLabel",
      defaultMessage: "Start datafeed after save",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }),
    checked: startDatafeedAfterSave,
    onChange: ({
      target: {
        checked
      }
    }) => {
      setStartDatafeedAfterSave(checked);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "useFullData",
    name: "useFullData",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.useFullDataLabel",
      defaultMessage: "Use full {dataViewIndexPattern} data",
      values: {
        dataViewIndexPattern: dataView.getIndexPattern()
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 15
      }
    }),
    checked: useFullIndexData,
    onChange: ({
      target: {
        checked
      }
    }) => {
      setUseFullIndexData(checked);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  })), !useFullIndexData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_components.TimeRangePicker, {
    setTimeRange: setTimeRange,
    timeRange: timeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedOptions",
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.recognize.advancedSettingsAriaLabel', {
      defaultMessage: 'Advanced settings'
    }),
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.advancedLabel",
      defaultMessage: "Advanced",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 13
      }
    }),
    paddingSize: "l",
    "data-test-subj": "mlJobWizardToggleAdvancedSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.useDedicatedIndexLabel",
      defaultMessage: "Use dedicated index",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 17
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.tooltips.newJobDedicatedIndexTooltip",
      defaultMessage: "Store results in a separate index for this job.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    describedByIds: ['ml_aria_label_new_job_dedicated_index'],
    "data-test-subj": "mlJobWizardAdvancedSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "useDedicatedIndex",
    name: "useDedicatedIndex",
    checked: useDedicatedIndex,
    onChange: ({
      target: {
        checked
      }
    }) => {
      setUseDedicatedIndex(checked);
    },
    label: _i18n.i18n.translate('xpack.ml.newJob.recognize.useDedicatedIndexLabel', {
      defaultMessage: 'Use dedicated index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    isLoading: saveState === _page.SAVE_STATE.SAVING,
    disabled: !validationResult.formValid || saveState === _page.SAVE_STATE.SAVING,
    onClick: () => {
      onSubmit(createJobSettings());
    },
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.recognize.createJobButtonAriaLabel', {
      defaultMessage: 'Create job'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.createJobButtonLabel",
    defaultMessage: "Create {numberOfJobs, plural, zero {job} one {job} other {jobs}}",
    values: {
      numberOfJobs: jobs.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  }))));
};
exports.JobSettingsForm = JobSettingsForm;