"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ForecastsList = ForecastsList;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/forecasting_modal/forecasts_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Lists details of previously run forecasts in a table.
 */
function getColumns(viewForecast) {
  return [{
    field: 'forecast_create_timestamp',
    name: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastsList.createdColumnName', {
      defaultMessage: 'Created'
    }),
    dataType: 'date',
    render: date => (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(date),
    sortable: true
  }, {
    field: 'forecast_start_timestamp',
    name: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastsList.fromColumnName', {
      defaultMessage: 'From'
    }),
    dataType: 'date',
    render: date => (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(date),
    sortable: true
  }, {
    field: 'forecast_end_timestamp',
    name: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastsList.toColumnName', {
      defaultMessage: 'To'
    }),
    dataType: 'date',
    render: date => (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(date),
    sortable: true
  }, {
    name: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastsList.viewColumnName', {
      defaultMessage: 'View'
    }),
    width: '60px',
    render: forecast => {
      const viewForecastAriaLabel = _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastsList.viewForecastAriaLabel', {
        defaultMessage: 'View forecast created at {createdDate}',
        values: {
          createdDate: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(forecast.forecast_create_timestamp)
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => viewForecast(forecast.forecast_id),
        iconType: "singleMetricViewer",
        "aria-label": viewForecastAriaLabel,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 11
        }
      });
    }
  }];
}
function ForecastsList({
  forecasts,
  viewForecast,
  selectedForecastId
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const getRowProps = item => {
    return {
      'data-test-subj': `mlForecastsListRow row-${item.rowId}`,
      ...(item.forecast_id === selectedForecastId ? {
        style: {
          backgroundColor: `${euiTheme.colors.backgroundBasePrimary}`
        }
      } : {})
    };
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "aria-describedby": "ml_aria_description_forecasting_modal_view_list",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastsList.previousForecastsTitle",
    defaultMessage: "Previous forecasts",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "s",
    type: "question",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.forecastsList.listsOfFiveRecentlyRunForecastsTooltip",
      defaultMessage: "Lists a maximum of five of the most recently run forecasts.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: forecasts,
    columns: getColumns(viewForecast),
    pagination: false,
    "data-test-subj": "mlModalForecastTable",
    rowProps: getRowProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }));
}
ForecastsList.propType = {
  forecasts: _propTypes.default.array,
  viewForecast: _propTypes.default.func.isRequired,
  selectedForecastId: _propTypes.default.string
};