"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlotByFunctionControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _job_service = require("../../../services/job_service");
var _get_function_description = require("../../get_function_description");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _results_service = require("../../../services/results_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/plot_function_controls/plot_function_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const plotByFunctionOptions = [{
  value: 'mean',
  text: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.plotByAvgOptionLabel', {
    defaultMessage: 'mean'
  })
}, {
  value: 'min',
  text: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.plotByMinOptionLabel', {
    defaultMessage: 'min'
  })
}, {
  value: 'max',
  text: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.plotByMaxOptionLabel', {
    defaultMessage: 'max'
  })
}];
const PlotByFunctionControls = ({
  functionDescription,
  job,
  setFunctionDescription,
  selectedDetectorIndex,
  selectedJobId,
  selectedEntities,
  entityControlsCount
}) => {
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const mlResultsService = (0, _results_service.useMlResultsService)();
  const mlJobService = (0, _job_service.useMlJobService)();
  const getFunctionDescriptionToPlot = (0, _react.useCallback)(async (_selectedDetectorIndex, _selectedEntities, _selectedJob) => {
    const functionToPlot = await (0, _get_function_description.getFunctionDescription)({
      selectedDetectorIndex: _selectedDetectorIndex,
      selectedEntities: _selectedEntities,
      selectedJob: _selectedJob
    }, toastNotificationService, mlResultsService);
    setFunctionDescription(functionToPlot);
  }, [setFunctionDescription, toastNotificationService, mlResultsService]);
  (0, _react.useEffect)(() => {
    if (functionDescription !== undefined) {
      return;
    }
    const selectedJob = job !== null && job !== void 0 ? job : mlJobService.getJob(selectedJobId);
    // if no controls, it's okay to fetch
    // if there are series controls, only fetch if user has selected something
    const validEntities = entityControlsCount === 0 || entityControlsCount > 0 && selectedEntities !== undefined;
    if (validEntities && functionDescription === undefined && (0, _get_function_description.isMetricDetector)(selectedJob, selectedDetectorIndex)) {
      const detector = selectedJob.analysis_config.detectors[selectedDetectorIndex];
      if ((detector === null || detector === void 0 ? void 0 : detector.function) === _mlAnomalyUtils.ML_JOB_AGGREGATION.METRIC) {
        getFunctionDescriptionToPlot(selectedDetectorIndex, selectedEntities, selectedJob);
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [setFunctionDescription, selectedDetectorIndex, selectedEntities, selectedJobId, functionDescription, entityControlsCount]);
  if (functionDescription === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.metricPlotByOption', {
      defaultMessage: 'Function'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: plotByFunctionOptions,
    value: functionDescription,
    onChange: e => setFunctionDescription(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.metricPlotByOptionLabel', {
      defaultMessage: 'Pick function to plot by (min, max, or average) if metric function'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })));
};
exports.PlotByFunctionControls = PlotByFunctionControls;