"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySwimlaneInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _kibana = require("../../application/contexts/kibana");
var _locator = require("../../../common/constants/locator");
var _job_utils = require("../../../common/util/job_utils");
var _job_selector = require("../../alerting/job_selector");
var _explorer_constants = require("../../application/explorer/explorer_constants");
var _anomaly_swimlane_embeddable = require("./anomaly_swimlane_embeddable");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/anomaly_swimlane/anomaly_swimlane_initializer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalySwimlaneInitializer = ({
  onCreate,
  onCancel,
  initialInput,
  adJobsApiService
}) => {
  var _initialInput$jobIds, _initialInput$title, _initialInput$swimlan;
  const isMounted = (0, _useMountedState.default)();
  const titleManuallyChanged = (0, _react.useRef)(!!(initialInput !== null && initialInput !== void 0 && initialInput.title));
  const [jobIds, setJobIds] = (0, _react.useState)((_initialInput$jobIds = initialInput === null || initialInput === void 0 ? void 0 : initialInput.jobIds) !== null && _initialInput$jobIds !== void 0 ? _initialInput$jobIds : []);
  const [influencers, setInfluencers] = (0, _react.useState)([_explorer_constants.VIEW_BY_JOB_LABEL]);
  (0, _react.useEffect)(function updateInfluencers() {
    async function fetchInfluencers() {
      const jobs = await adJobsApiService.jobs(jobIds);
      if (isMounted()) {
        setInfluencers([...(0, _job_utils.extractInfluencers)(jobs), _explorer_constants.VIEW_BY_JOB_LABEL]);
      }
    }
    if (jobIds.length > 0) {
      fetchInfluencers();
    }
  }, [adJobsApiService, isMounted, jobIds]);
  const [panelTitle, setPanelTitle] = (0, _react.useState)((_initialInput$title = initialInput === null || initialInput === void 0 ? void 0 : initialInput.title) !== null && _initialInput$title !== void 0 ? _initialInput$title : '');
  const [swimlaneType, setSwimlaneType] = (0, _react.useState)((_initialInput$swimlan = initialInput === null || initialInput === void 0 ? void 0 : initialInput.swimlaneType) !== null && _initialInput$swimlan !== void 0 ? _initialInput$swimlan : _explorer_constants.SWIMLANE_TYPE.OVERALL);
  const [viewBySwimlaneFieldName, setViewBySwimlaneFieldName] = (0, _react.useState)(initialInput === null || initialInput === void 0 ? void 0 : initialInput.viewBy);
  (0, _react.useEffect)(function updateDefaultTitle() {
    if (!titleManuallyChanged.current) {
      setPanelTitle((0, _anomaly_swimlane_embeddable.getDefaultSwimlanePanelTitle)(jobIds));
    }
  }, [initialInput === null || initialInput === void 0 ? void 0 : initialInput.title, jobIds]);
  const swimlaneTypeOptions = [{
    id: _explorer_constants.SWIMLANE_TYPE.OVERALL,
    label: _i18n.i18n.translate('xpack.ml.explorer.overallLabel', {
      defaultMessage: 'Overall'
    })
  }, {
    id: _explorer_constants.SWIMLANE_TYPE.VIEW_BY,
    label: _i18n.i18n.translate('xpack.ml.explorer.viewByLabel', {
      defaultMessage: 'View by'
    })
  }];
  const viewBySwimlaneOptions = ['', ...influencers].map(influencer => {
    return {
      value: influencer,
      text: influencer
    };
  });
  const isPanelTitleValid = panelTitle.length > 0;
  const jobIdsErrors = (0, _utils.getJobSelectionErrors)(jobIds);
  const isFormValid = isPanelTitleValid && !jobIdsErrors && (swimlaneType === _explorer_constants.SWIMLANE_TYPE.OVERALL || swimlaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY && !!viewBySwimlaneFieldName);
  const resultInput = {
    jobIds,
    panelTitle,
    swimlaneType,
    ...(viewBySwimlaneFieldName ? {
      viewBy: viewBySwimlaneFieldName
    } : {})
  };
  const newJobUrl = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.title",
    defaultMessage: "Anomaly swim lane configuration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_job_selector.JobSelectorControl, {
    createJobUrl: newJobUrl,
    multiSelect: true,
    jobsAndGroupIds: jobIds,
    adJobsApiService: adJobsApiService,
    onChange: update => {
      var _update$jobIds, _update$groupIds;
      setJobIds([...((_update$jobIds = update === null || update === void 0 ? void 0 : update.jobIds) !== null && _update$jobIds !== void 0 ? _update$jobIds : []), ...((_update$groupIds = update === null || update === void 0 ? void 0 : update.groupIds) !== null && _update$groupIds !== void 0 ? _update$groupIds : [])]);
    },
    errors: jobIdsErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }), jobIds.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.swimlaneEmbeddable.panelTitleLabel",
      defaultMessage: "Panel title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 19
      }
    }),
    isInvalid: !isPanelTitleValid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    id: "panelTitle",
    name: "panelTitle",
    value: panelTitle,
    onChange: e => {
      titleManuallyChanged.current = true;
      setPanelTitle(e.target.value);
    },
    isInvalid: !isPanelTitleValid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.swimlaneEmbeddable.setupModal.swimlaneTypeLabel",
      defaultMessage: "Swim lane type",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 19
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    id: "selectSwimlaneType",
    name: "selectSwimlaneType",
    color: "primary",
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.ml.swimlaneEmbeddable.setupModal.swimlaneTypeLabel', {
      defaultMessage: 'Swim lane type'
    }),
    options: swimlaneTypeOptions,
    idSelected: swimlaneType,
    onChange: id => setSwimlaneType(id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  }))) : null, swimlaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.viewByLabel",
      defaultMessage: "View by",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 19
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    id: "selectViewBy",
    name: "selectViewBy",
    options: viewBySwimlaneOptions,
    value: viewBySwimlaneFieldName,
    onChange: e => setViewBySwimlaneFieldName(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: !isFormValid,
    onClick: onCreate.bind(null, resultInput),
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }))))));
};
exports.AnomalySwimlaneInitializer = AnomalySwimlaneInitializer;