"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapAsMonacoSuggestions = wrapAsMonacoSuggestions;
var _monaco_imports = require("../../../../monaco_imports");
var _utils = require("../shared/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function escapeForStringLiteral(str) {
  return str.replace(/\\/g, '\\\\').replace(/"/g, '\\"');
}
function wrapAsMonacoSuggestions(suggestions, fullText, defineRange = true, escapeSpecialChars = false) {
  let hasAnIncompleteSuggestion = false;
  const monacoSuggestions = suggestions.map(({
    label,
    text,
    asSnippet,
    kind,
    detail,
    documentation,
    sortText,
    filterText,
    command,
    rangeToReplace,
    incomplete
  }) => {
    if (incomplete) {
      hasAnIncompleteSuggestion = true;
    }
    const monacoSuggestion = {
      label,
      insertText: escapeSpecialChars ? escapeForStringLiteral(text) : text,
      filterText,
      kind: kind in _monaco_imports.monaco.languages.CompletionItemKind ? _monaco_imports.monaco.languages.CompletionItemKind[kind] : _monaco_imports.monaco.languages.CompletionItemKind.Method,
      // fallback to Method
      detail,
      documentation,
      sortText,
      command,
      insertTextRules: asSnippet ? _monaco_imports.monaco.languages.CompletionItemInsertTextRule.InsertAsSnippet : undefined,
      range: rangeToReplace && defineRange ? (0, _utils.offsetRangeToMonacoRange)(fullText, rangeToReplace) : undefined
    };
    return monacoSuggestion;
  });
  return {
    incomplete: hasAnIncompleteSuggestion,
    // @ts-expect-error because of range typing: https://github.com/microsoft/monaco-editor/issues/4638
    suggestions: monacoSuggestions
  };
}