"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Beat = Beat;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _chart = require("../../chart");
var _format_number = require("../../../lib/format_number");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _summary_status = require("../../summary_status");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/components/beats/beat/beat.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Beat({
  summary,
  metrics,
  ...props
}) {
  const metricsToShow = [metrics.beat_event_rates, metrics.beat_fail_rates, metrics.beat_throughput_rates, metrics.beat_output_errors, metrics.beat_memory, metrics.beat_cpu_utilization, metrics.beat_os_load, metrics.beat_handles];
  const summarytStatsTop = [{
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.nameLabel', {
      defaultMessage: 'Name'
    }),
    value: summary.name,
    'data-test-subj': 'name'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.hostLabel', {
      defaultMessage: 'Host'
    }),
    value: summary.transportAddress,
    'data-test-subj': 'host'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.versionLabel', {
      defaultMessage: 'Version'
    }),
    value: summary.version,
    'data-test-subj': 'version'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.typeLabel', {
      defaultMessage: 'Type'
    }),
    value: summary.type,
    'data-test-subj': 'type'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.outputLabel', {
      defaultMessage: 'Output'
    }),
    value: summary.output,
    'data-test-subj': 'output'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.configReloadsLabel', {
      defaultMessage: 'Config reloads'
    }),
    value: (0, _format_number.formatMetric)(summary.configReloads, 'int_commas'),
    'data-test-subj': 'configReloads'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.uptimeLabel', {
      defaultMessage: 'Uptime'
    }),
    value: (0, _format_number.formatMetric)(summary.uptime, 'time_since'),
    'data-test-subj': 'uptime'
  }];
  const summarytStatsBot = [{
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.eventsTotalLabel', {
      defaultMessage: 'Events total'
    }),
    value: (0, _format_number.formatMetric)(summary.eventsTotal, 'int_commas'),
    'data-test-subj': 'eventsTotal'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.eventsEmittedLabel', {
      defaultMessage: 'Events emitted'
    }),
    value: (0, _format_number.formatMetric)(summary.eventsEmitted, 'int_commas'),
    'data-test-subj': 'eventsEmitted'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.eventsDroppedLabel', {
      defaultMessage: 'Events dropped'
    }),
    value: (0, _format_number.formatMetric)(summary.eventsDropped, 'int_commas'),
    'data-test-subj': 'eventsDropped'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.bytesSentLabel', {
      defaultMessage: 'Bytes sent'
    }),
    value: (0, _format_number.formatMetric)(summary.bytesWritten, 'byte'),
    'data-test-subj': 'bytesWritten'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.handlesLimitSoftLabel', {
      defaultMessage: 'Handles limit (soft)'
    }),
    value: (0, _format_number.formatMetric)(summary.handlesSoftLimit, 'int_commas'),
    'data-test-subj': 'handlesLimitSoft'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.beats.instance.handlesLimitHardLabel', {
      defaultMessage: 'Handles limit (hard)'
    }),
    value: (0, _format_number.formatMetric)(summary.handlesHardLimit, 'int_commas'),
    'data-test-subj': 'handlesLimitHard'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: summarytStatsTop,
    "data-test-subj": "beatSummaryStatus01",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: summarytStatsBot,
    "data-test-subj": "beatSummaryStatus02",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.beats.beat.heading",
    defaultMessage: "Beat",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, metricsToShow.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: metric
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  })))))));
}