"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Listing = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _legacy_shims = require("../../../legacy_shims");
var _table = require("../../table");
var _status2 = require("../../../alerts/status");
var _constants = require("../../../../common/constants");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/components/cluster/listing/listing.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const clusterCellExpiredStyle = ({
  euiTheme
}) => (0, _react2.css)`
  color: ${euiTheme.colors.textParagraph};
`;
const clusterCellLicenseStyle = theme => (0, _react2.css)`
  font-size: ${(0, _eui.euiFontSize)(theme, 'm').fontSize};
`;
const clusterCellExpirationStyle = ({
  euiTheme
}) => (0, _react2.css)`
  color: ${euiTheme.colors.darkShade};
`;
const IsClusterSupported = ({
  isSupported,
  children
}) => {
  return isSupported ? children : '-';
};

/*
 * This checks if alerts feature is supported via monitoring cluster
 * license. If the alerts feature is not supported because the prod cluster
 * license is basic, IsClusterSupported makes the status col hidden
 * completely
 */
const IsAlertsSupported = props => {
  const {
    alertsMeta = {
      enabled: true
    }
  } = props.cluster.alerts;
  if (alertsMeta.enabled) {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 12
      }
    }, props.children);
  }
  const message = _i18n.i18n.translate('xpack.monitoring.cluster.listing.unknownHealthMessage', {
    defaultMessage: 'Unknown'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: message,
    position: "bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    "data-test-subj": "alertIcon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, "N/A"));
};
const STANDALONE_CLUSTER_STORAGE_KEY = 'viewedStandaloneCluster';
const getColumns = (showLicenseExpiration, _changeCluster, handleClickIncompatibleLicense, handleClickInvalidLicense) => {
  return [{
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    field: 'cluster_name',
    sortable: true,
    render: (value, cluster) => {
      if (cluster.isSupported) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/overview`, {
            cluster_uuid: cluster.cluster_uuid
          }),
          "data-test-subj": "clusterLink",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 13
          }
        }, value);
      }

      // not supported because license is basic/not compatible with multi-cluster
      if (cluster.license) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => handleClickIncompatibleLicense(cluster.cluster_name),
          "data-test-subj": "clusterLink",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 13
          }
        }, value);
      }

      // not supported because license is invalid
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => handleClickInvalidLicense(cluster.cluster_name),
        "data-test-subj": "clusterLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 11
        }
      }, value);
    }
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.statusColumnTitle', {
      defaultMessage: 'Alerts Status'
    }),
    field: 'status',
    'data-test-subj': 'alertsStatus',
    sortable: true,
    render: (_status, cluster) => /*#__PURE__*/_react.default.createElement(IsClusterSupported, (0, _extends2.default)({}, cluster, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(IsAlertsSupported, {
      cluster: cluster,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_status2.AlertsStatus, {
      alerts: cluster.alerts.list,
      showBadge: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    })))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.nodesColumnTitle', {
      defaultMessage: 'Nodes'
    }),
    field: 'elasticsearch.cluster_stats.nodes.count.total',
    'data-test-subj': 'nodesCount',
    sortable: true,
    render: (total, cluster) => /*#__PURE__*/_react.default.createElement(IsClusterSupported, (0, _extends2.default)({}, cluster, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }), typeof total === 'number' ? (0, _numeral.default)(total).format('0,0') : 0)
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.indicesColumnTitle', {
      defaultMessage: 'Indices'
    }),
    field: 'elasticsearch.cluster_stats.indices.count',
    'data-test-subj': 'indicesCount',
    sortable: true,
    render: (count, cluster) => /*#__PURE__*/_react.default.createElement(IsClusterSupported, (0, _extends2.default)({}, cluster, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }), (0, _numeral.default)(count).format('0,0'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.dataColumnTitle', {
      defaultMessage: 'Data'
    }),
    field: 'elasticsearch.cluster_stats.indices.store.size_in_bytes',
    'data-test-subj': 'dataSize',
    sortable: true,
    render: (size, cluster) => /*#__PURE__*/_react.default.createElement(IsClusterSupported, (0, _extends2.default)({}, cluster, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }), (0, _numeral.default)(size).format('0,0[.]0 b'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.logstashColumnTitle', {
      defaultMessage: 'Logstash'
    }),
    field: 'logstash.node_count',
    'data-test-subj': 'logstashCount',
    sortable: true,
    render: (count, cluster) => /*#__PURE__*/_react.default.createElement(IsClusterSupported, (0, _extends2.default)({}, cluster, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 9
      }
    }), (0, _numeral.default)(count).format('0,0'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.kibanaColumnTitle', {
      defaultMessage: 'Kibana'
    }),
    field: 'kibana.count',
    'data-test-subj': 'kibanaCount',
    sortable: true,
    render: (count, cluster) => /*#__PURE__*/_react.default.createElement(IsClusterSupported, (0, _extends2.default)({}, cluster, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 9
      }
    }), (0, _numeral.default)(count).format('0,0'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.licenseColumnTitle', {
      defaultMessage: 'License'
    }),
    field: 'license.type',
    'data-test-subj': 'clusterLicense',
    sortable: true,
    render: (licenseType, cluster) => {
      const license = cluster.license;
      if (!licenseType) {
        return /*#__PURE__*/_react.default.createElement("div", {
          css: clusterCellLicenseStyle,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 211,
            columnNumber: 18
          }
        }, "N/A");
      }
      if (license) {
        const licenseExpiry = () => {
          if (license.expiry_date_in_millis < (0, _moment.default)().valueOf()) {
            // license is expired
            return /*#__PURE__*/_react.default.createElement("span", {
              css: clusterCellExpiredStyle,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 218,
                columnNumber: 22
              }
            }, "Expired");
          }

          // license is fine
          return /*#__PURE__*/_react.default.createElement("span", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 222,
              columnNumber: 20
            }
          }, "Expires ", (0, _moment.default)(license.expiry_date_in_millis).format('D MMM YY'));
        };
        return /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 226,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          css: clusterCellLicenseStyle,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 227,
            columnNumber: 15
          }
        }, (0, _lodash.capitalize)(licenseType)), /*#__PURE__*/_react.default.createElement("div", {
          css: clusterCellExpirationStyle,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 228,
            columnNumber: 15
          }
        }, showLicenseExpiration ? licenseExpiry() : null));
      }

      // there is no license!
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => handleClickInvalidLicense(cluster.cluster_name),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: "subdued",
        "data-test-subj": "alertIcon",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 13
        }
      }, "N/A"));
    }
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.cluster.listing.versionColumnTitle', {
      defaultMessage: 'Version'
    }),
    field: 'version',
    'data-test-subj': 'clusterVersion',
    sortable: true
  }];
};
const changeCluster = (scope, globalState, clusterUuid, ccs) => {
  scope.$evalAsync(() => {
    globalState.cluster_uuid = clusterUuid;
    globalState.ccs = ccs;
    globalState.save();
    window.history.replaceState(null, null, '#/overview');
  });
};
const licenseWarning = (scope, {
  title,
  text
}) => {
  scope.$evalAsync(() => {
    _legacy_shims.Legacy.shims.toastNotifications.addWarning({
      title,
      text,
      'data-test-subj': 'monitoringLicenseWarning'
    });
  });
};
const handleClickIncompatibleLicense = (scope, services, clusterName) => {
  licenseWarning(scope, {
    title: _i18n.i18n.translate('xpack.monitoring.cluster.listing.incompatibleLicense.warningMessageTitle', {
      defaultMessage: "You can't view the {clusterName} cluster",
      values: {
        clusterName: '"' + clusterName + '"'
      }
    }),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.cluster.listing.incompatibleLicense.noMultiClusterSupportMessage",
      defaultMessage: "The Basic license does not support multi-cluster monitoring.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.cluster.listing.incompatibleLicense.infoMessage",
      defaultMessage: "Need to monitor multiple clusters? {getLicenseInfoLink} to enjoy multi-cluster monitoring.",
      values: {
        getLicenseInfoLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: "https://www.elastic.co/subscriptions",
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 298,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.monitoring.cluster.listing.incompatibleLicense.getLicenseLinkLabel",
          defaultMessage: "Get a license with full functionality",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 299,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 11
      }
    }))), services)
  });
};
const handleClickInvalidLicense = (scope, services, clusterName) => {
  const licensingPath = `${_legacy_shims.Legacy.shims.getBasePath()}/app/management/stack/license_management/home`;
  licenseWarning(scope, {
    title: _i18n.i18n.translate('xpack.monitoring.cluster.listing.invalidLicense.warningMessageTitle', {
      defaultMessage: "You can't view the {clusterName} cluster",
      values: {
        clusterName: '"' + clusterName + '"'
      }
    }),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 323,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.cluster.listing.invalidLicense.invalidInfoMessage",
      defaultMessage: "The license information is invalid.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.cluster.listing.invalidLicense.infoMessage",
      defaultMessage: "Need a license? {getBasicLicenseLink} or {getLicenseInfoLink} to enjoy multi-cluster monitoring.",
      values: {
        getBasicLicenseLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: licensingPath,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 336,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.monitoring.cluster.listing.invalidLicense.getBasicLicenseLinkLabel",
          defaultMessage: "Get a free Basic license",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 337,
            columnNumber: 19
          }
        })),
        getLicenseInfoLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: "https://www.elastic.co/subscriptions",
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 344,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.monitoring.cluster.listing.invalidLicense.getLicenseLinkLabel",
          defaultMessage: "Get a license with full functionality",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 345,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 11
      }
    }))), services)
  });
};
const StandaloneClusterCallout = ({
  changeCluster,
  storage
}) => {
  if (storage.get(STANDALONE_CLUSTER_STORAGE_KEY)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: _i18n.i18n.translate('xpack.monitoring.cluster.listing.standaloneClusterCallOutTitle', {
      defaultMessage: "It looks like you have instances that aren't connected to an Elasticsearch cluster."
    }),
    iconType: "link",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => changeCluster(_constants.STANDALONE_CLUSTER_CLUSTER_UUID),
    "data-test-subj": "standaloneClusterLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.listing.standaloneClusterCallOutLink",
    defaultMessage: "View these instances.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 13
    }
  })), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.listing.standaloneClusterCallOutText",
    defaultMessage: "Or, click Standalone Cluster in the table below",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      storage.set(STANDALONE_CLUSTER_STORAGE_KEY, true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "cross",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 13
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.listing.standaloneClusterCallOutDismiss",
    defaultMessage: "Dismiss",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 7
    }
  }));
};
const Listing = ({
  angular,
  clusters,
  sorting,
  pagination,
  onTableChange
}) => {
  const {
    scope,
    globalState,
    storage,
    showLicenseExpiration
  } = angular;
  const {
    sort: {
      direction,
      field
    }
  } = sorting;
  const {
    services
  } = (0, _public.useKibana)();
  const _changeCluster = (0, _lodash.partial)(changeCluster, scope, globalState);
  const _handleClickIncompatibleLicense = (0, _lodash.partial)(handleClickIncompatibleLicense, scope, services);
  const _handleClickInvalidLicense = (0, _lodash.partial)(handleClickInvalidLicense, scope, services);
  const hasStandaloneCluster = !!clusters.find(cluster => cluster.cluster_uuid === _constants.STANDALONE_CLUSTER_CLUSTER_UUID);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 9
    }
  }, hasStandaloneCluster ? /*#__PURE__*/_react.default.createElement(StandaloneClusterCallout, {
    changeCluster: _changeCluster,
    storage: storage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    "data-test-subj": "clusterTable",
    rows: clusters,
    columns: getColumns(showLicenseExpiration, _changeCluster, _handleClickIncompatibleLicense, _handleClickInvalidLicense),
    rowProps: item => {
      return {
        'data-test-subj': `clusterRow_${item.cluster_uuid}`
      };
    },
    sorting: {
      sort: {
        direction,
        field: field || 'cluster_name'
      }
    },
    pagination: pagination,
    search: {
      box: {
        incremental: true,
        placeholder: scope.filterText
      }
    },
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['cluster_name']
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 11
    }
  }))));
};
exports.Listing = Listing;