"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BytesPercentageUsage = BytesPercentageUsage;
exports.BytesUsage = BytesUsage;
exports.ClusterItemContainer = ClusterItemContainer;
exports.DisabledIfNoDataAndInSetupModeLink = DisabledIfNoDataAndInSetupModeLink;
exports.HealthLabel = HealthLabel;
exports.HealthStatusIndicator = HealthStatusIndicator;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _legacy_shims = require("../../../legacy_shims");
var _format_number = require("../../../lib/format_number");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/components/cluster/overview/helpers.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function HealthLabel(props) {
  if (props.status === 'green') {
    return _i18n.i18n.translate('xpack.monitoring.cluster.health.healthy', {
      defaultMessage: 'Healthy'
    });
  }
  const {
    product,
    status
  } = props;
  if (product === 'es') {
    if (props.status === 'yellow') {
      return _i18n.i18n.translate('xpack.monitoring.cluster.health.replicaShards', {
        defaultMessage: 'Missing replica shards'
      });
    }
    if (props.status === 'red') {
      return _i18n.i18n.translate('xpack.monitoring.cluster.health.primaryShards', {
        defaultMessage: 'Missing primary shards'
      });
    }
  }

  // TODO: Use the actual service level statuses instead of converting them to colors
  if (product === 'kb' && (status === 'yellow' || status === 'red')) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.monitoring.cluster.health.pluginIssues', {
      defaultMessage: 'Some plugins may be experiencing issues. Please check '
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: `${_legacy_shims.Legacy.shims.getBasePath()}/status`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }, "the Kibana status page"), ".");
  }
  return 'N/A';
}
function HealthStatusIndicator(props) {
  const statusColorMap = {
    green: 'success',
    yellow: 'warning',
    red: 'danger'
  };
  const statusColor = statusColorMap[props.status] || 'n/a';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: statusColor,
    "data-test-subj": "status",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(HealthLabel, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  })))));
}
const PanelExtras = ({
  extras
}) => {
  if (extras === undefined) {
    return null;
  }

  // mimic the spacing of an EuiHealth which this is adjacent to
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 10
    }
  }, extras);
};
function ClusterItemContainer(props) {
  const iconMap = {
    elasticsearch: 'logoElasticsearch',
    kibana: 'logoKibana',
    logstash: 'logoLogstash',
    beats: 'logoBeats',
    apm: 'apmApp',
    enterprise_search: 'logoEnterpriseSearch'
  };
  const icon = iconMap[props.url];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `clusterItemContainer${props.title}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 17
    }
  }, props.title))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, props.statusIndicator), /*#__PURE__*/_react.default.createElement(PanelExtras, {
    extras: props.extras,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }), props.children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }));
}
function BytesUsage({
  usedBytes,
  maxBytes
}) {
  if (usedBytes && maxBytes) {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }, (0, _format_number.formatBytesUsage)(usedBytes, maxBytes)));
  } else if (usedBytes) {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    }, (0, _format_number.formatNumber)(usedBytes, 'byte')));
  }
  return null;
}
function BytesPercentageUsage({
  usedBytes,
  maxBytes
}) {
  if (usedBytes && maxBytes) {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }, (0, _format_number.formatPercentageUsage)(usedBytes, maxBytes)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }, (0, _format_number.formatBytesUsage)(usedBytes, maxBytes)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 10
    }
  }, "0");
}
function DisabledIfNoDataAndInSetupModeLink({
  setupModeEnabled,
  setupModeData,
  children,
  ...props
}) {
  if (setupModeEnabled && (0, _lodash.get)(setupModeData, 'totalUniqueInstanceCount', 0) === 0) {
    return children;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 10
    }
  }), children);
}