"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MachineLearningJobStatusIcon = MachineLearningJobStatusIcon;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _status_icon = require("../../status_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/ml_job_listing/status_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MachineLearningJobStatusIcon({
  status
}) {
  const type = (() => {
    const statusKey = status.toUpperCase();
    if (statusKey === 'OPENED') {
      return _status_icon.STATUS_ICON_TYPES.GREEN;
    } else if (statusKey === 'CLOSED') {
      return _status_icon.STATUS_ICON_TYPES.GRAY;
    } else if (statusKey === 'FAILED') {
      return _status_icon.STATUS_ICON_TYPES.RED;
    }

    // basically a "changing" state like OPENING or CLOSING
    return _status_icon.STATUS_ICON_TYPES.YELLOW;
  })();
  return /*#__PURE__*/_react.default.createElement(_status_icon.StatusIcon, {
    type: type,
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.statusIconLabel', {
      defaultMessage: 'Job Status: {status}',
      values: {
        status
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
}