"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _polished = require("polished");
var _public = require("@kbn/unified-search-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/components/kuery_bar/suggestion_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SuggestionItem = ({
  isSelected = false,
  onClick,
  onMouseEnter,
  suggestion
}) => {
  return (
    /*#__PURE__*/
    // TODO: should be focusable and have relevant key events; try using an existing component from EUI
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events
    _react.default.createElement("div", {
      css: suggestionItemContainerStyle(isSelected),
      onClick: onClick,
      onMouseEnter: onMouseEnter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: suggestionItemIconFieldStyle(suggestion.type),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: getEuiIconType(suggestion.type),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      css: suggestionItemTextFieldStyle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, suggestion.text), /*#__PURE__*/_react.default.createElement("div", {
      css: suggestionItemDescriptionFieldStyle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, suggestion.description))
  );
};
exports.SuggestionItem = SuggestionItem;
const suggestionItemContainerStyle = isSelected => theme => (0, _react2.css)`
    display: flex;
    flex-direction: row;
    font-size: ${(0, _eui.euiFontSize)(theme, 's').fontSize};
    height: ${theme.euiTheme.size.xl};
    white-space: nowrap;
    background-color: ${isSelected ? theme.euiTheme.colors.lightestShade : 'transparent'};
  `;
const suggestionItemFieldStyle = ({
  euiTheme
}) => (0, _react2.css)`
  align-items: center;
  cursor: pointer;
  display: flex;
  flex-direction: row;
  height: ${euiTheme.size.xl};
  padding: ${euiTheme.size.xs};
`;
const suggestionItemIconFieldStyle = suggestionType => theme => (0, _react2.css)`
      ${suggestionItemFieldStyle(theme)};
      background-color: ${(0, _polished.transparentize)(0.9, getEuiIconColor(theme, suggestionType))};
      color: ${getEuiIconColor(theme, suggestionType)};
      flex: 0 0 auto;
      justify-content: center;
      width: ${theme.euiTheme.size.xl};
    `;
const suggestionItemTextFieldStyle = theme => (0, _react2.css)`
  ${suggestionItemFieldStyle(theme)};
  flex: 2 0 0;
  font-family: ${theme.euiTheme.font.familyCode};
`;
const suggestionItemDescriptionFieldStyle = theme => (0, _react2.css)`
  ${suggestionItemFieldStyle(theme)};
  flex: 3 0 0;

  p {
    display: inline;

    span {
      font-family: ${theme.euiTheme.font.familyCode};
    }
  }
`;
const getEuiIconType = suggestionType => {
  switch (suggestionType) {
    case _public.QuerySuggestionTypes.Field:
      return 'kqlField';
    case _public.QuerySuggestionTypes.Value:
      return 'kqlValue';
    case _public.QuerySuggestionTypes.RecentSearch:
      return 'search';
    case _public.QuerySuggestionTypes.Conjunction:
      return 'kqlSelector';
    case _public.QuerySuggestionTypes.Operator:
      return 'kqlOperand';
    default:
      return 'empty';
  }
};
const getEuiIconColor = ({
  euiTheme
}, suggestionType) => {
  switch (suggestionType) {
    case _public.QuerySuggestionTypes.Field:
      return euiTheme.colors.vis.euiColorVis7;
    case _public.QuerySuggestionTypes.Value:
      return euiTheme.colors.vis.euiColorVis0;
    case _public.QuerySuggestionTypes.Operator:
      return euiTheme.colors.vis.euiColorVis1;
    case _public.QuerySuggestionTypes.Conjunction:
      return euiTheme.colors.vis.euiColorVis2;
    case _public.QuerySuggestionTypes.RecentSearch:
    default:
      return euiTheme.colors.mediumShade;
  }
};