"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _constants = require("../../common/constants");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/rule_connector/ai_assistant_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ObsAIAssistantParamsFields = ({
  errors,
  index,
  messageVariables,
  editAction,
  actionParams,
  service
}) => {
  var _errors$connector, _actionParams$prompts, _actionParams$prompts2, _actionParams$prompts3;
  const {
    connectors,
    loading,
    selectConnector,
    selectedConnector
  } = (0, _public.useGenAIConnectorsWithoutContext)(service);
  (0, _react.useEffect)(() => {
    if (selectedConnector !== actionParams.connector) {
      editAction('connector', selectedConnector, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams, selectedConnector, index]);
  (0, _react.useEffect)(() => {
    // Ensure backwards compatibility by using the message field as a prompt if prompts are missing
    if (!actionParams.prompts) {
      editAction('prompts', [{
        statuses: _constants.ALERT_STATUSES,
        message: actionParams.message || ''
      }], index);
    }
    // forward-compatible fallback.
    if (actionParams.prompts && actionParams.prompts[0].message !== actionParams.message) {
      editAction('message', actionParams.prompts[0].message, index);
    }
  }, [actionParams, editAction, index]);
  const handleOnChange = (key, value, promptIndex) => {
    const prompts = actionParams.prompts ? [...actionParams.prompts] : [];
    prompts[promptIndex] = {
      ...prompts[promptIndex],
      [key]: value
    };
    editAction('prompts', prompts, index);
  };
  const handleAddPrompt = () => {
    if (actionParams.prompts) {
      const prompts = [...actionParams.prompts, {
        statuses: _constants.ALERT_STATUSES,
        message: ''
      }];
      editAction('prompts', prompts, index);
    }
  };
  const handleRemovePrompt = () => {
    if (actionParams.prompts) {
      const prompts = actionParams.prompts.slice(0, -1);
      editAction('prompts', prompts, index);
    }
  };
  const isValidField = (statusError, promptIndex) => {
    var _errors$prompts;
    const errorsList = ((_errors$prompts = errors.prompts) === null || _errors$prompts === void 0 ? void 0 : _errors$prompts[promptIndex]) || [];
    return errorsList.includes(statusError);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistant.alertConnector.selectLlmConnector', {
      defaultMessage: 'Connector'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "observabilityAiAssistantAlertConnectorSelect",
    isLoading: loading
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: ((_errors$connector = errors.connector) === null || _errors$connector === void 0 ? void 0 : _errors$connector.length) > 0,
    options: connectors === null || connectors === void 0 ? void 0 : connectors.map(connector => {
      return {
        value: connector.id,
        text: connector.name
      };
    }),
    onChange: event => {
      selectConnector(event.target.value);
      editAction('connector', event.target.value, index);
    },
    value: actionParams.connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })), actionParams === null || actionParams === void 0 ? void 0 : (_actionParams$prompts = actionParams.prompts) === null || _actionParams$prompts === void 0 ? void 0 : _actionParams$prompts.map((prompt, promptIndex) => /*#__PURE__*/_react.default.createElement("div", {
    key: promptIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistant.alertConnector.messageTextAreaFieldLabel', {
      defaultMessage: 'On status changes'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    id: `addNewActionConnectorActionGroup-${index}`,
    "data-test-subj": `addNewActionConnectorActionGroup-${index}`,
    options: _constants.ALERT_STATUSES.map(id => ({
      label: id
    })),
    selectedOptions: prompt.statuses.map(id => ({
      label: id
    })),
    onChange: statuses => {
      handleOnChange('statuses', statuses.map(status => status.label), promptIndex);
    },
    isClearable: true,
    isInvalid: isValidField(_translations.STATUS_REQUIRED, promptIndex),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistant.alertConnector.messageTextAreaFieldLabel', {
      defaultMessage: 'Message'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    "data-test-subj": "observabilityAiAssistantAlertConnectorMessageTextArea",
    value: prompt.message,
    onChange: event => {
      handleOnChange('message', event.target.value, promptIndex);
    },
    isInvalid: isValidField(_translations.MESSAGE_REQUIRED, promptIndex),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: (actionParams === null || actionParams === void 0 ? void 0 : (_actionParams$prompts2 = actionParams.prompts) === null || _actionParams$prompts2 === void 0 ? void 0 : _actionParams$prompts2.length) === 1,
    size: "m",
    fullWidth: true,
    color: "danger",
    iconType: "minusInCircle",
    "data-test-subj": "removePropmptButton",
    onClick: handleRemovePrompt,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityAiAssistant.alertConnector.removePromptButtonLabel",
    defaultMessage: "Remove Prompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: (actionParams === null || actionParams === void 0 ? void 0 : (_actionParams$prompts3 = actionParams.prompts) === null || _actionParams$prompts3 === void 0 ? void 0 : _actionParams$prompts3.length) === _constants.ALERT_STATUSES.length,
    size: "m",
    fullWidth: true,
    iconType: "plusInCircle",
    "data-test-subj": "addPrompButton",
    onClick: handleAddPrompt,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityAiAssistant.alertConnector.addPromptButtonLabel",
    defaultMessage: "Add Prompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = ObsAIAssistantParamsFields;
module.exports = exports.default;