"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelKubernetesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _react2 = require("@emotion/react");
var _ebtTools = require("@kbn/ebt-tools");
var _common = require("@kbn/logs-shared-plugin/common");
var _pricing_features = require("../../../../common/pricing_features");
var _empty_prompt = require("../shared/empty_prompt");
var _get_started_panel = require("../shared/get_started_panel");
var _feedback_buttons = require("../shared/feedback_buttons");
var _copy_to_clipboard_button = require("../shared/copy_to_clipboard_button");
var _use_kubernetes_flow = require("../kubernetes/use_kubernetes_flow");
var _use_flow_breadcrumbs = require("../../shared/use_flow_breadcrumbs");
var _build_install_stack_command = require("./build_install_stack_command");
var _constants = require("./constants");
var _build_values_file_url = require("./build_values_file_url");
var _use_managed_otlp_service_availability = require("../../shared/use_managed_otlp_service_availability");
var _use_pricing_feature = require("../shared/use_pricing_feature");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/otel_kubernetes/otel_kubernetes_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OtelKubernetesPanel = () => {
  var _dashboardLocator$get, _apmLocator$getRedire, _logsLocator$getRedir;
  (0, _use_flow_breadcrumbs.useFlowBreadcrumb)({
    text: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.breadcrumbs.k8sOtel', {
      defaultMessage: 'Kubernetes: OpenTelemetry'
    })
  });
  const {
    data,
    error,
    refetch
  } = (0, _use_kubernetes_flow.useKubernetesFlow)('kubernetes_otel');
  const [idSelected, setIdSelected] = (0, _react.useState)('nodejs');
  const {
    services: {
      share
    }
  } = (0, _public.useKibana)();
  const apmLocator = share.url.locators.get('APM_LOCATOR');
  const dashboardLocator = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const logsLocator = share.url.locators.get(_common.LOGS_LOCATOR_ID);
  const theme = (0, _eui.useEuiTheme)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const isMetricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const isManagedOtlpServiceAvailable = (0, _use_managed_otlp_service_availability.useManagedOtlpServiceAvailability)();
  (0, _react.useEffect)(() => {
    if (data) {
      onPageReady({
        meta: {
          description: `[ttfmp_onboarding] Request to create the onboarding flow succeeded and the flow's UI has rendered`
        }
      });
    }
  }, [data, onPageReady]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      onboardingFlowType: "kubernetes_otel",
      error: error,
      onRetryClick: refetch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    });
  }
  const addRepoCommand = `helm repo add open-telemetry '${_constants.OTEL_HELM_CHARTS_REPO}' --force-update`;
  const otelKubeStackValuesFileUrl = data ? (0, _build_values_file_url.buildValuesFileUrl)({
    isMetricsOnboardingEnabled,
    isManagedOtlpServiceAvailable,
    agentVersion: data.elasticAgentVersionInfo.agentBaseVersion
  }) : undefined;
  const installStackCommand = data ? (0, _build_install_stack_command.buildInstallStackCommand)({
    isMetricsOnboardingEnabled,
    isManagedOtlpServiceAvailable,
    managedOtlpEndpointUrl: data.managedOtlpServiceUrl,
    elasticsearchUrl: data.elasticsearchUrl,
    apiKeyEncoded: data.apiKeyEncoded,
    agentVersion: data.elasticAgentVersionInfo.agentBaseVersion
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.addRepositoryStepTitle', {
        defaultMessage: 'Add the OpenTelemetry repository to Helm'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "bash",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 17
        }
      }, addRepoCommand), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
        textToCopy: addRepoCommand,
        "data-test-subj": "observabilityOnboardingOtelKubernetesPanelAddRepositoryCopyToClipboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 17
        }
      }))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.installStackStepTitle', {
        defaultMessage: 'Install the OpenTelemetry Operator'
      }),
      children: installStackCommand ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.otelKubernetesPanel.injectAutoinstrumentationLibrariesForLabel",
        defaultMessage: "Install the OpenTelemetry Operator using the kube-stack Helm chart and the provided values file. For automatic certificate renewal, we recommend installing the {link}, and customize the values.yaml file before the installation as described {doc}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://cert-manager.io/docs/installation/",
            target: "_blank",
            "data-test-subj": "observabilityOnboardingOtelKubernetesPanelCertManagerLink",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 145,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.certmanagerLinkLabel', {
            defaultMessage: 'cert-manager'
          })),
          doc: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://ela.st/8-16-otel-cert-manager",
            target: "_blank",
            "data-test-subj": "observabilityOnboardingOtelKubernetesPanelCertManagerDocsLink",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 157,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.certmanagerDocsLinkLabel', {
            defaultMessage: 'in our documentation'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 19
        }
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.helmsAutogeneratedTLSCertificatesTextLabel', {
          defaultMessage: "Helm's autogenerated TLS certificates have a default expiration period of 365 days. These certificates are not renewed automatically unless the release is manually updated. Enabling cert-manager allows for automatic certificate renewal."
        }),
        position: "top",
        type: "info",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "bash",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 17
        }
      }, installStackCommand), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        justifyContent: "flexStart",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
        textToCopy: installStackCommand,
        "data-test-subj": "observabilityOnboardingOtelKubernetesPanelInstallStackCopyToClipboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "download",
        href: otelKubeStackValuesFileUrl,
        flush: "left",
        target: "_blank" // The `download` attribute does not work cross-origin so it's better to open the file in a new tab
        ,
        "data-test-subj": "observabilityOnboardingOtelKubernetesPanelDownloadValuesFileButton",
        "aria-label": _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.downloadValuesFileAriaLabel', {
          defaultMessage: 'Download the values file for OpenTelemetry setup'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.downloadValuesFileButtonEmptyLabel', {
        defaultMessage: 'Download values file'
      }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 6,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 15
        }
      })
    }, ...(isMetricsOnboardingEnabled ? [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.instrumentApplicationStepTitle', {
        defaultMessage: 'Instrument your application (optional)'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.theOperatorAutomatesTheLabel', {
        defaultMessage: 'The Operator automates the injection of auto-instrumentation libraries into the annotated pods for some languages.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        legend: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.selectProgrammingLanguageLegend', {
          defaultMessage: 'Select a programming language'
        }),
        idSelected: idSelected,
        onChange: optionId => setIdSelected(optionId),
        options: [{
          id: 'nodejs',
          label: 'Node.js'
        }, {
          id: 'java',
          label: 'Java'
        }, {
          id: 'python',
          label: 'Python'
        }, {
          id: 'dotnet',
          label: '.NET'
        }, {
          id: 'go',
          label: 'Go'
        }],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 271,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement("p", {
        css: (0, _react2.css)`
                          font-weight: ${theme.euiTheme.font.weight.bold};
                        `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.step3a.title', {
        defaultMessage: '3(a) - Start with one of these annotations methods:'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: 'otelKubernetesAccordionSingleDeployment',
        paddingSize: "s",
        buttonContent: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.annotation.deployment', {
          defaultMessage: 'Annotate specific deployment Pods modifying its manifest'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "yaml",
        isCopyable: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 25
        }
      }, `apiVersion: apps/v1
kind: Deployment
metadata:
  name: myapp
spec:
  ...
  template:
    metadata:
      annotations:
        instrumentation.opentelemetry.io/inject-${idSelected}: "${_constants.OTEL_STACK_NAMESPACE}/elastic-instrumentation"
      ...
    spec:
      containers:
      - image: myapplication-image
        name: app
      ...`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 315,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: 'otelKubernetesAccordionAllResources',
        paddingSize: "s",
        buttonContent: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.annotation.resources', {
          defaultMessage: 'Annotate all resources in a namespace'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 316,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "bash",
        isCopyable: true,
        "data-test-subj": "observabilityOnboardingOtelKubernetesPanelAnnotateAllResourcesSnippet",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 324,
          columnNumber: 25
        }
      }, `kubectl annotate namespace my-namespace instrumentation.opentelemetry.io/inject-${idSelected}="${_constants.OTEL_STACK_NAMESPACE}/elastic-instrumentation"`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 333,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement("p", {
        css: (0, _react2.css)`
                          font-weight: ${theme.euiTheme.font.weight.bold};
                        `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 334,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.step3b.title', {
        defaultMessage: '3(b) - Restart deployment and ensure the annotations are applied and the auto-instrumentation library is injected:'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 347,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "bash",
        isCopyable: true,
        "data-test-subj": "observabilityOnboardingOtelKubernetesPanelRestartDeploymentSnippet",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 348,
          columnNumber: 23
        }
      }, `kubectl rollout restart deployment myapp -n my-namespace

kubectl describe pod <myapp-pod-name> -n my-namespace`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 358,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 359,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.otelKubernetesPanel.forOtherLanguagesThatLabel",
        defaultMessage: "For other languages where auto-instrumentation is not available, {link}",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://ela.st/8-16-otel-apm-instrumentation",
            "data-test-subj": "observabilityOnboardingOtelKubernetesPanelReferToTheDocumentationLink",
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 365,
              columnNumber: 31
            }
          }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.referToTheDocumentationLinkLabel', {
            defaultMessage: 'refer to the documentation'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 25
        }
      })))
    }] : []), {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.monitorStepTitle', {
        defaultMessage: 'Visualize your data'
      }),
      children: data ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 17
        }
      }, isMetricsOnboardingEnabled && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.otelKubernetesPanel.onceYourKubernetesInfrastructureLabel",
        defaultMessage: "Analyze your Kubernetes cluster\u2019s health and monitor your container workloads.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 395,
          columnNumber: 21
        }
      }), !isMetricsOnboardingEnabled && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.logsEssentials.otelKubernetesPanel.onceYourKubernetesInfrastructureLabel",
        defaultMessage: "After running the previous command, come back and view your data.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 401,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 407,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_get_started_panel.GetStartedPanel, {
        onboardingFlowType: "kubernetes_otel",
        onboardingId: data.onboardingId,
        dataset: "kubernetes",
        integration: "kubernetes_otel",
        newTab: false,
        isLoading: false,
        actionLinks: isMetricsOnboardingEnabled ? [{
          id: _constants.CLUSTER_OVERVIEW_DASHBOARD_ID,
          title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.monitoringCluster', {
            defaultMessage: 'Check your Kubernetes cluster health:'
          }),
          label: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.exploreDashboard', {
            defaultMessage: 'Explore Kubernetes Cluster Dashboard'
          }),
          href: (_dashboardLocator$get = dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
            dashboardId: _constants.CLUSTER_OVERVIEW_DASHBOARD_ID
          })) !== null && _dashboardLocator$get !== void 0 ? _dashboardLocator$get : ''
        }, {
          id: 'services',
          title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.servicesTitle', {
            defaultMessage: 'Check your application services:'
          }),
          label: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.servicesLabel', {
            defaultMessage: 'Explore Service inventory'
          }),
          href: (_apmLocator$getRedire = apmLocator === null || apmLocator === void 0 ? void 0 : apmLocator.getRedirectUrl({
            serviceName: undefined
          })) !== null && _apmLocator$getRedire !== void 0 ? _apmLocator$getRedire : ''
        }] : [{
          id: 'logs',
          title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.logsTitle', {
            defaultMessage: 'View and analyze your logs:'
          }),
          label: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.logsLabel', {
            defaultMessage: 'Explore logs'
          }),
          href: (_logsLocator$getRedir = logsLocator === null || logsLocator === void 0 ? void 0 : logsLocator.getRedirectUrl({})) !== null && _logsLocator$getRedir !== void 0 ? _logsLocator$getRedir : ''
        }],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 408,
          columnNumber: 17
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 6,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 476,
          columnNumber: 15
        }
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
    flow: "otel_kubernetes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 481,
      columnNumber: 7
    }
  }));
};
exports.OtelKubernetesPanel = OtelKubernetesPanel;