"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPending = exports.FETCH_STATUS = void 0;
exports.useFetcher = useFetcher;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _use_kibana = require("./use_kibana");
var _create_call_api = require("../services/rest/create_call_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/hooks/use_fetcher.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let FETCH_STATUS = exports.FETCH_STATUS = /*#__PURE__*/function (FETCH_STATUS) {
  FETCH_STATUS["LOADING"] = "loading";
  FETCH_STATUS["SUCCESS"] = "success";
  FETCH_STATUS["FAILURE"] = "failure";
  FETCH_STATUS["NOT_INITIATED"] = "not_initiated";
  return FETCH_STATUS;
}({});
const isPending = fetchStatus => fetchStatus === FETCH_STATUS.LOADING || fetchStatus === FETCH_STATUS.NOT_INITIATED;
exports.isPending = isPending;
function getDetailsFromErrorResponse(error) {
  var _error$body$message, _error$body, _error$response, _error$response2, _error$response3;
  const message = (_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.statusText;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, message, " (", (_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.status, ")", /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.fetcher.error.url', {
    defaultMessage: `URL`
  })), (_error$response3 = error.response) === null || _error$response3 === void 0 ? void 0 : _error$response3.url);
}
const createAutoAbortedClient = (signal, addInspectorRequest) => {
  return (endpoint, options) => {
    return (0, _create_call_api.callObservabilityOnboardingApi)(endpoint, {
      ...options,
      signal
    }).catch(err => {
      var _err$body;
      addInspectorRequest({
        status: FETCH_STATUS.FAILURE,
        data: (_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.attributes
      });
      throw err;
    }).then(response => {
      addInspectorRequest({
        data: response,
        status: FETCH_STATUS.SUCCESS
      });
      return response;
    });
  };
};

// fetcher functions can return undefined OR a promise. Previously we had a more simple type
// but it led to issues when using object destructuring with default values

function useFetcher(fn, fnDeps, options = {}) {
  const {
    services: {
      notifications,
      rendering
    }
  } = (0, _use_kibana.useKibana)();
  const {
    preservePreviousData = true,
    showToastOnError = true
  } = options;
  const [result, setResult] = (0, _react.useState)({
    data: undefined,
    status: FETCH_STATUS.NOT_INITIATED
  });
  const [counter, setCounter] = (0, _react.useState)(0);
  const {
    addInspectorRequest
  } = (0, _public.useInspectorContext)();
  (0, _react.useEffect)(() => {
    let controller = new AbortController();
    async function doFetch() {
      controller.abort();
      controller = new AbortController();
      const signal = controller.signal;
      const promise = fn(createAutoAbortedClient(signal, addInspectorRequest));
      // if `fn` doesn't return a promise it is a signal that data fetching was not initiated.
      // This can happen if the data fetching is conditional (based on certain inputs).
      // In these cases it is not desirable to invoke the global loading spinner, or change the status to success
      if (!promise) {
        return;
      }
      setResult(prevResult => ({
        data: preservePreviousData ? prevResult.data : undefined,
        // preserve data from previous state while loading next state
        status: FETCH_STATUS.LOADING,
        error: undefined
      }));
      try {
        const data = await promise;
        // when http fetches are aborted, the promise will be rejected
        // and this code is never reached. For async operations that are
        // not cancellable, we need to check whether the signal was
        // aborted before updating the result.
        if (!signal.aborted) {
          setResult({
            data,
            status: FETCH_STATUS.SUCCESS,
            error: undefined
          });
        }
      } catch (e) {
        const err = e;
        if (!signal.aborted) {
          const errorDetails = 'response' in err ? getDetailsFromErrorResponse(err) : err.message;
          if (showToastOnError) {
            notifications.toasts.addDanger({
              title: _i18n.i18n.translate('xpack.observability_onboarding.fetcher.error.title', {
                defaultMessage: `Error while fetching resource`
              }),
              text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("div", {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 149,
                  columnNumber: 17
                }
              }, /*#__PURE__*/_react.default.createElement("h5", {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 150,
                  columnNumber: 19
                }
              }, _i18n.i18n.translate('xpack.observability_onboarding.fetcher.error.status', {
                defaultMessage: `Error`
              })), errorDetails), rendering)
            });
          }
          setResult({
            data: undefined,
            status: FETCH_STATUS.FAILURE,
            error: e
          });
        }
      }
    }
    doFetch();
    return () => {
      controller.abort();
    };
    /* eslint-disable react-hooks/exhaustive-deps */
  }, [counter, preservePreviousData, showToastOnError, ...fnDeps
  /* eslint-enable react-hooks/exhaustive-deps */]);
  return (0, _react.useMemo)(() => {
    return {
      ...result,
      refetch: () => {
        // this will invalidate the deps to `useEffect` and will result in a new request
        setCounter(count => count + 1);
      }
    };
  }, [result]);
}