"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAlertSearchBar = ObservabilityAlertSearchBar;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alert_filter_controls = require("@kbn/alerts-ui-shared/src/alert_filter_controls");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _public = require("@kbn/controls-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../common/constants");
var _constants2 = require("./constants");
var _build_es_query = require("../../utils/build_es_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/components/alert_search_bar/alert_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const toastTitle = _i18n.i18n.translate('xpack.observability.alerts.searchBar.invalidQueryTitle', {
  defaultMessage: 'Invalid query string'
});
const getTimeFilter = timeRange => (0, _common.getTime)(undefined, timeRange, {
  fieldName: _ruleDataUtils.ALERT_TIME_RANGE
});
function ObservabilityAlertSearchBar({
  appName,
  defaultFilters = _constants2.EMPTY_FILTERS,
  disableLocalStorageSync,
  onEsQueryChange,
  onKueryChange,
  onRangeFromChange,
  onRangeToChange,
  onControlConfigsChange,
  onFiltersChange,
  onFilterControlsChange,
  showFilterBar = false,
  controlConfigs,
  filters = _constants2.EMPTY_FILTERS,
  filterControls,
  savedQuery,
  setSavedQuery,
  kuery,
  rangeFrom,
  rangeTo,
  onControlApiAvailable,
  services: {
    AlertsSearchBar,
    timeFilterService,
    http,
    notifications,
    dataViews,
    spaces,
    useToasts,
    uiSettings
  }
}) {
  const toasts = useToasts();
  const [spaceId, setSpaceId] = (0, _react.useState)();
  const [timeFilter, setTimeFilter] = (0, _react.useState)(getTimeFilter({
    to: rangeTo,
    from: rangeFrom
  }));
  const queryFilter = kuery ? {
    query: kuery,
    language: 'kuery'
  } : undefined;
  const {
    data: indexNames
  } = (0, _alertsUiShared.useFetchAlertsIndexNamesQuery)({
    http,
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES
  });
  const clearSavedQuery = (0, _react.useCallback)(() => setSavedQuery ? setSavedQuery(undefined) : null, [setSavedQuery]);
  const filterControlsStorageKey = (0, _react.useMemo)(() => ['observabilitySearchBar', spaceId, appName, 'filterControls'].filter(Boolean).join('.'), [appName, spaceId]);
  const dataViewSpec = (0, _react.useMemo)(() => {
    var _indexNames$join;
    return {
      id: 'observability-unified-alerts-dv',
      title: (_indexNames$join = indexNames === null || indexNames === void 0 ? void 0 : indexNames.join(',')) !== null && _indexNames$join !== void 0 ? _indexNames$join : ''
    };
  }, [indexNames]);
  const aggregatedFilters = (0, _react.useMemo)(() => {
    const _filters = timeFilter ? [timeFilter, ...filters, ...defaultFilters] : [...filters, ...defaultFilters];
    return _filters.length ? _filters : undefined;
  }, [timeFilter, filters, defaultFilters]);
  const submitQuery = (0, _react.useCallback)(() => {
    try {
      onEsQueryChange((0, _build_es_query.buildEsQuery)({
        timeRange: {
          to: rangeTo,
          from: rangeFrom
        },
        kuery,
        filters: [...filters, ...(filterControls !== null && filterControls !== void 0 ? filterControls : []), ...defaultFilters],
        config: (0, _common.getEsQueryConfig)(uiSettings)
      }));
      setTimeFilter(getTimeFilter({
        to: rangeTo,
        from: rangeFrom
      }));
    } catch (error) {
      toasts.addError(error, {
        title: toastTitle
      });
      onKueryChange(_constants2.DEFAULT_QUERY_STRING);
    }
  }, [onEsQueryChange, rangeTo, rangeFrom, kuery, defaultFilters, filters, filterControls, uiSettings, toasts, onKueryChange]);
  (0, _react.useEffect)(() => {
    submitQuery();
  }, [submitQuery]);
  (0, _react.useEffect)(() => {
    if (spaces) {
      spaces.getActiveSpace().then(space => setSpaceId(space.id));
    }
  }, [spaces]);
  const onQuerySubmit = ({
    dateRange,
    query
  }, isUpdate) => {
    if (isUpdate) {
      clearSavedQuery();
      onKueryChange(query !== null && query !== void 0 ? query : '');
      timeFilterService.setTime(dateRange);
      onRangeFromChange(dateRange.from);
      onRangeToChange(dateRange.to);
    } else {
      submitQuery();
    }
  };
  const onFilterUpdated = (0, _react.useCallback)(updatedFilters => {
    clearSavedQuery();
    onFiltersChange === null || onFiltersChange === void 0 ? void 0 : onFiltersChange(updatedFilters);
  }, [clearSavedQuery, onFiltersChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AlertsSearchBar, {
    appName: appName,
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    showFilterBar: showFilterBar,
    filters: filters,
    onFiltersUpdated: onFilterUpdated,
    savedQuery: savedQuery,
    onSavedQueryUpdated: setSavedQuery,
    onClearSavedQuery: clearSavedQuery,
    query: kuery,
    onQuerySubmit: onQuerySubmit,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, indexNames && indexNames.length > 0 && /*#__PURE__*/_react.default.createElement(_alert_filter_controls.AlertFilterControls, {
    dataViewSpec: dataViewSpec,
    spaceId: spaceId,
    chainingSystem: "HIERARCHICAL",
    controlsUrlState: controlConfigs,
    setControlsUrlState: onControlConfigsChange,
    filters: aggregatedFilters,
    onFiltersChange: onFilterControlsChange,
    storageKey: filterControlsStorageKey,
    disableLocalStorageSync: disableLocalStorageSync,
    query: queryFilter,
    services: {
      http,
      notifications,
      dataViews,
      storage: _public2.Storage
    },
    ControlGroupRenderer: _public.ControlGroupRenderer,
    onInit: onControlApiAvailable,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  })));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = ObservabilityAlertSearchBar;