"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationRange = AnnotationRange;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/annotation_range.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getHelpfulDateFormat = dateFormat => {
  if (dateFormat.endsWith('HH:mm:ss.SSS')) {
    // we don't want microseconds in the date picker
    return dateFormat.replace(':ss.SSS', ':ss');
  }
  return dateFormat;
};
function AnnotationRange() {
  const {
    control,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const eventEnd = watch('event.end');
  const dateFormatDefault = (0, _public.useUiSetting)('dateFormat');
  const dateFormat = getHelpfulDateFormat(dateFormatDefault);
  if (eventEnd) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.date', {
        defaultMessage: 'Timestamp'
      }),
      display: "rowCompressed",
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
      name: "@timestamp",
      control: control,
      rules: {
        required: true
      },
      render: ({
        field
      }) => {
        const {
          value,
          ref,
          ...rest
        } = field;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, (0, _extends2.default)({
          showTimeSelect: true,
          selected: field.value,
          fullWidth: true,
          compressed: true,
          prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 55,
              columnNumber: 21
            }
          }, _i18n.i18n.translate('xpack.observability.annotationRange.fromFormLabelLabel', {
            defaultMessage: 'From'
          })),
          dateFormat: dateFormat
        }, rest, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 17
          }
        }));
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "rowCompressed",
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
      name: "event.end",
      control: control,
      rules: {
        required: true
      },
      render: ({
        field
      }) => {
        const {
          value,
          ref,
          ...rest
        } = field;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, (0, _extends2.default)({
          showTimeSelect: true,
          selected: field.value,
          fullWidth: true,
          compressed: true,
          prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 84,
              columnNumber: 21
            }
          }, _i18n.i18n.translate('xpack.observability.annotationRange.toFormLabelLabel', {
            defaultMessage: 'To'
          })),
          dateFormat: dateFormat
        }, rest, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 78,
            columnNumber: 17
          }
        }));
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.annotationDate', {
      defaultMessage: 'Annotation date'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "@timestamp",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field
    }) => {
      const {
        value,
        ref,
        ...rest
      } = field;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, (0, _extends2.default)({
        showTimeSelect: true,
        selected: field.value,
        compressed: true,
        dateFormat: dateFormat
      }, rest, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 13
        }
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }));
}