"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObsCasesContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../utils/kibana_react");
var _common = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/obs_cases_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ObsCasesContext = ({
  children
}) => {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    cases
  } = services;
  const userCasesPermissions = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases([_common.observabilityFeatureId]);
  const CasesContext = cases === null || cases === void 0 ? void 0 : cases.ui.getCasesContext();
  if (userCasesPermissions && CasesContext) {
    return /*#__PURE__*/_react.default.createElement(CasesContext, {
      owner: [_common.observabilityFeatureId],
      permissions: userCasesPermissions,
      features: {
        alerts: {
          sync: false
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 7
      }
    }, children);
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
};
exports.ObsCasesContext = ObsCasesContext;