"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderRuleStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _common = require("@kbn/kibana-react-plugin/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alerts/components/rule_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Divider = _common.euiStyled.div`
  border-right: 1px solid ${_uiTheme.euiThemeVars.euiColorLightShade};
  height: 100%;
`;
const StyledStat = (0, _common.euiStyled)(_eui.EuiStat)`
  .euiText {
    line-height: 1;
  }
`;
const ConditionalWrap = ({
  condition,
  wrap,
  children
}) => condition ? wrap(children) : children;
const getStatCount = (stats, status) => {
  if (status === 'snoozed') return stats.snoozed + stats.muted;
  return stats[status];
};
const disabledLabel = _i18n.i18n.translate('xpack.observability.alerts.ruleStats.disabled', {
  defaultMessage: 'Disabled'
});
const snoozedLabel = _i18n.i18n.translate('xpack.observability.alerts.ruleStats.muted', {
  defaultMessage: 'Snoozed'
});
const errorsLabel = _i18n.i18n.translate('xpack.observability.alerts.ruleStats.errors', {
  defaultMessage: 'Errors'
});
const renderRuleStats = (ruleStats, manageRulesHref, ruleStatsLoading, rulesLocator) => {
  const handleNavigateToRules = async (stats, status) => {
    const count = getStatCount(stats, status);
    if (count > 0) {
      switch (status) {
        case 'error':
          await (rulesLocator === null || rulesLocator === void 0 ? void 0 : rulesLocator.navigate({
            lastResponse: ['failed']
          }, {
            replace: false
          }));
          break;
        case 'snoozed':
        case 'disabled':
          await (rulesLocator === null || rulesLocator === void 0 ? void 0 : rulesLocator.navigate({
            status: [status]
          }, {
            replace: false
          }));
          break;
        default:
          break;
      }
    }
  };
  const disabledStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.disabled > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": disabledLabel,
      "data-test-subj": "o11yDisabledStatsComponentButton",
      onClick: () => handleNavigateToRules(ruleStats, 'disabled'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }, wrappedChildren),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.disabled,
    description: disabledLabel,
    color: "primary",
    titleColor: ruleStats.disabled > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statDisabled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }));
  const snoozedStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.muted + ruleStats.snoozed > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": snoozedLabel,
      "data-test-subj": "o11ySnoozedStatsComponentButton",
      onClick: () => handleNavigateToRules(ruleStats, 'snoozed'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, wrappedChildren),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.muted + ruleStats.snoozed,
    description: snoozedLabel,
    color: "primary",
    titleColor: ruleStats.muted + ruleStats.snoozed > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statMuted",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }));
  const errorStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.error > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": errorsLabel,
      "data-test-subj": "o11yErrorStatsComponentButton",
      onClick: () => handleNavigateToRules(ruleStats, 'error'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }, wrappedChildren),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.error,
    description: errorsLabel,
    color: "primary",
    titleColor: ruleStats.error > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statErrors",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }));
  return [/*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.total,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.ruleCount', {
      defaultMessage: 'Rule count'
    }),
    color: "primary",
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statRuleCount",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  }), disabledStatsComponent, snoozedStatsComponent, errorStatsComponent, /*#__PURE__*/_react.default.createElement(Divider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "manageRulesPageButton",
    href: manageRulesHref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.observability.alerts.manageRulesButtonLabel', {
    defaultMessage: 'Manage Rules'
  }))].reverse();
};
exports.renderRuleStats = renderRuleStats;