"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostLink = HostLink;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/metrics/host_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function HostLink({
  name,
  id,
  timerange
}) {
  var _services$share;
  const {
    services
  } = (0, _public.useKibana)();
  const assetDetailsLocator = (_services$share = services.share) === null || _services$share === void 0 ? void 0 : _services$share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  const href = assetDetailsLocator === null || assetDetailsLocator === void 0 ? void 0 : assetDetailsLocator.getRedirectUrl({
    entityType: 'host',
    entityId: id,
    assetDetails: {
      dateRange: {
        from: new Date(timerange.from).toISOString(),
        to: new Date(timerange.to).toISOString()
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("a", {
    href: href,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, name));
}