"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConfirmationModal = DeleteConfirmationModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_delete_rules = require("../../../hooks/use_delete_rules");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/pages/rule_details/components/delete_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DeleteConfirmationModal({
  ruleIdToDelete,
  title,
  onCancel,
  onDeleted,
  onDeleting
}) {
  const [isVisible, setIsVisible] = (0, _react.useState)(Boolean(ruleIdToDelete));
  const {
    mutateAsync: deleteRules
  } = (0, _use_delete_rules.useDeleteRules)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const handleConfirm = async () => {
    if (ruleIdToDelete) {
      setIsVisible(false);
      onDeleting();
      await deleteRules({
        ids: [ruleIdToDelete]
      });
      onDeleted();
    }
  };
  return isVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "deleteIdsConfirmation",
    title: _i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.descriptionText', {
      defaultMessage: "You can't recover {title} after deleting.",
      values: {
        title
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.deleteButtonLabel', {
      defaultMessage: 'Delete {title}',
      values: {
        title
      }
    }),
    onCancel: onCancel,
    onConfirm: handleConfirm,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.descriptionText', {
    defaultMessage: "You can't recover {title} after deleting.",
    values: {
      title
    }
  })) : null;
}