"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActiveToolsStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../utils/app_paths");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/edit/active_tools_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ActiveToolsStatus = ({
  activeToolsCount,
  warningThreshold
}) => {
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const isOverThreshold = activeToolsCount > warningThreshold;
  const isZeroTools = activeToolsCount === 0;
  const shouldShowWarning = isOverThreshold || isZeroTools;
  const statusColor = shouldShowWarning ? 'warning' : 'success';
  const iconType = shouldShowWarning ? 'alert' : 'checkInCircleFilled';
  const statusMessage = shouldShowWarning ? _i18n.i18n.translate('xpack.onechat.activeToolsStatus.warningStatusMessage', {
    defaultMessage: 'Warning status: {count} active tools',
    values: {
      count: activeToolsCount
    }
  }) : _i18n.i18n.translate('xpack.onechat.activeToolsStatus.goodStatusMessage', {
    defaultMessage: 'Good status: {count} active tools',
    values: {
      count: activeToolsCount
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "m",
    "aria-label": _i18n.i18n.translate('xpack.onechat.activeToolsStatus.panelLabel', {
      defaultMessage: 'Active tools status panel'
    }),
    role: "region",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    color: statusColor,
    size: "m",
    "aria-label": shouldShowWarning ? _i18n.i18n.translate('xpack.onechat.activeToolsStatus.warningStatusIcon', {
      defaultMessage: 'Warning status icon'
    }) : _i18n.i18n.translate('xpack.onechat.activeToolsStatus.successStatusIcon', {
      defaultMessage: 'Success status icon'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: statusColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    "aria-label": statusMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.onechat.activeToolsStatus.title', {
    defaultMessage: 'This agent has {count} active tools',
    values: {
      count: activeToolsCount
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.activeToolsStatus.description",
    defaultMessage: "{toolsLink} enable agents to work with your data. For best results, keep the selection under {threshold} to avoid overwhelming your agent with too many options.",
    values: {
      toolsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: createOnechatUrl(_app_paths.appPaths.tools.list),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.onechat.activeToolsStatus.toolsLinkText', {
        defaultMessage: 'Tools'
      })),
      threshold: warningThreshold
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: activeToolsCount,
    max: warningThreshold,
    color: statusColor,
    size: "m",
    label: _i18n.i18n.translate('xpack.onechat.activeToolsStatus.progressLabel', {
      defaultMessage: 'Active tools'
    }),
    valueText: `${activeToolsCount}/${warningThreshold}`,
    "aria-label": _i18n.i18n.translate('xpack.onechat.activeToolsStatus.progressAriaLabel', {
      defaultMessage: 'Progress: {current} out of {max} active tools',
      values: {
        current: activeToolsCount,
        max: warningThreshold
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }))))));
};
exports.ActiveToolsStatus = ActiveToolsStatus;