"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationSidebar = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _conversation_sections = require("./conversation_sections");
var _conversation_sidebar_nav = require("./conversation_sidebar_nav");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_sidebar/conversation_sidebar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const sidebarContainerStyles = (0, _react.css)`
  block-size: 100%;
`;
const loadingStyles = (0, _react.css)`
  align-self: center;
  justify-content: center;
`;
const ConversationSidebar = ({
  conversations,
  isLoading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const scrollStyles = (0, _react.css)`
    ${(0, _eui.useEuiOverflowScroll)('y')}
  `;
  const conversationsContainerStyles = (0, _react.css)`
    padding: ${euiTheme.size.base};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: sidebarContainerStyles,
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: loadingStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: scrollStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: conversationsContainerStyles,
    direction: "column",
    gutterSize: "l",
    "aria-label": _i18n.i18n.translate('xpack.onechat.conversationSidebar.conversations', {
      defaultMessage: 'Conversations'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation_sections.ConversationSections, {
    conversations: conversations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation_sidebar_nav.ConversationSidebarNav, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })));
};
exports.ConversationSidebar = ConversationSidebar;