"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditVisualizationButton = EditVisualizationButton;
exports.saveButtonLabel = exports.editButtonLabel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/esql/visualize_esql/edit_visualization_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const editButtonLabel = exports.editButtonLabel = _i18n.i18n.translate('xpack.onechat.conversation.visualization.edit', {
  defaultMessage: 'Edit visualization'
});
const saveButtonLabel = exports.saveButtonLabel = _i18n.i18n.translate('xpack.onechat.conversation.visualization.saveToDashboard', {
  defaultMessage: 'Save to dashboard'
});
function EditVisualizationButton({
  uiActions,
  lensInput,
  lensLoadEvent,
  onAttributesChange,
  onApply
}) {
  const editModalOptions = (0, _react.useMemo)(() => {
    if (!(lensInput !== null && lensInput !== void 0 && lensInput.attributes)) {
      return;
    }
    return {
      applyButtonLabel: saveButtonLabel,
      attributes: lensInput.attributes,
      lensEvent: lensLoadEvent !== null && lensLoadEvent !== void 0 ? lensLoadEvent : {
        adapters: {}
      },
      onUpdate: onAttributesChange,
      onApply,
      onCancel: () => {},
      container: null
    };
  }, [lensInput, lensLoadEvent, onAttributesChange, onApply]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: editButtonLabel,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    color: "text",
    size: "s",
    iconType: "pencil",
    "aria-label": editButtonLabel,
    onClick: () => {
      if (editModalOptions) {
        uiActions.getTrigger('IN_APP_EMBEDDABLE_EDIT_TRIGGER').exec(editModalOptions);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
}