"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsTableHeader = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _tools_provider = require("../../../context/tools_provider");
var _i18n = require("../../../utils/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/table/tools_table_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ToolsTableHeader = ({
  isLoading,
  pageIndex,
  tools,
  total,
  selectedTools,
  setSelectedTools
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    bulkDeleteTools
  } = (0, _tools_provider.useToolsActions)();
  const selectAll = (0, _react2.useCallback)(() => {
    setSelectedTools(tools.filter(tool => !tool.readonly));
  }, [setSelectedTools, tools]);
  const clearSelection = (0, _react2.useCallback)(() => {
    setSelectedTools([]);
  }, [setSelectedTools]);
  const deleteSelection = (0, _react2.useCallback)(() => {
    bulkDeleteTools(selectedTools.map(tool => tool.id));
  }, [bulkDeleteTools, selectedTools]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
      css: (0, _react.css)`
            display: inline-block;
            width: 200px;
          `,
      lines: 1,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }),
    loadedContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      css: (0, _react.css)`
            min-height: 24px;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.tools.toolsTableSummary",
      defaultMessage: "Showing {start}-{end} of {total} {tools}",
      values: {
        start: /*#__PURE__*/_react2.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 24
          }
        }, Math.min(pageIndex * 10 + 1, tools.length)),
        end: /*#__PURE__*/_react2.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 81,
            columnNumber: 22
          }
        }, Math.min((pageIndex + 1) * 10, tools.length)),
        total,
        tools: /*#__PURE__*/_react2.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 24
          }
        }, _i18n.labels.tools.toolsLabel)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    })), selectedTools.length > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "trash",
      iconSize: "m",
      size: "xs",
      color: "danger",
      onClick: deleteSelection,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      css: (0, _react.css)`
                    font-weight: ${euiTheme.font.weight.semiBold};
                  `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 17
      }
    }, _i18n.labels.tools.deleteSelectedToolsButtonLabel(selectedTools.length))), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "pagesSelect",
      iconSize: "m",
      size: "xs",
      onClick: selectAll,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      css: (0, _react.css)`
                    font-weight: ${euiTheme.font.weight.semiBold};
                  `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 17
      }
    }, _i18n.labels.tools.selectAllToolsButtonLabel)), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      iconSize: "m",
      size: "xs",
      onClick: clearSelection,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      css: (0, _react.css)`
                    font-weight: ${euiTheme.font.weight.semiBold};
                  `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 17
      }
    }, _i18n.labels.tools.clearSelectionButtonLabel)))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  });
};
exports.ToolsTableHeader = ToolsTableHeader;