"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.painlessContextOptions = exports.exampleScript = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/painless_lab/public/application/constants.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultLabel = _i18n.i18n.translate('xpack.painlessLab.contextDefaultLabel', {
  defaultMessage: 'Basic'
});
const filterLabel = _i18n.i18n.translate('xpack.painlessLab.contextFilterLabel', {
  defaultMessage: 'Filter'
});
const scoreLabel = _i18n.i18n.translate('xpack.painlessLab.contextScoreLabel', {
  defaultMessage: 'Score'
});
const painlessContextOptions = exports.painlessContextOptions = [{
  value: 'painless_test',
  inputDisplay: defaultLabel,
  'data-test-subj': 'basicButtonDropdown',
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, defaultLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.painlessLab.context.defaultLabel', {
    defaultMessage: 'The script result will be converted to a string'
  }))))
}, {
  value: 'filter',
  inputDisplay: filterLabel,
  'data-test-subj': 'filterButtonDropdown',
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, filterLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.painlessLab.context.filterLabel', {
    defaultMessage: "Use the context of a filter's script query"
  }))))
}, {
  value: 'score',
  inputDisplay: scoreLabel,
  'data-test-subj': 'scoreButtonDropdown',
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, scoreLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.painlessLab.context.scoreLabel', {
    defaultMessage: 'Use the context of a script_score function in function_score query'
  }))))
}];

// Render a smiley face as an example.
const exampleScript = exports.exampleScript = `boolean isInCircle(def posX, def posY, def circleX, def circleY, def radius) {
  double distanceFromCircleCenter = Math.sqrt(Math.pow(circleX - posX, 2) + Math.pow(circleY - posY, 2));
  return distanceFromCircleCenter <= radius;
}

boolean isOnCircle(def posX, def posY, def circleX, def circleY, def radius, def thickness, def squashY) {
  double distanceFromCircleCenter = Math.sqrt(Math.pow(circleX - posX, 2) + Math.pow((circleY - posY) / squashY, 2));
  return (
    distanceFromCircleCenter >= radius - thickness
    && distanceFromCircleCenter <= radius + thickness
  );
}

def result = '';
int charCount = 0;

// Canvas dimensions
int width = 31;
int height = 31;
double halfWidth = Math.floor(width * 0.5);
double halfHeight = Math.floor(height * 0.5);

// Style constants
double strokeWidth = 0.6;

// Smiley face configuration
int headSize = 13;
double headSquashY = 0.78;
int eyePositionX = 10;
int eyePositionY = 12;
int eyeSize = 1;
int mouthSize = 15;
int mouthPositionX = width / 2;
int mouthPositionY = 5;
int mouthOffsetY = 11;

for (int y = 0; y < height; y++) {
  for (int x = 0; x < width; x++) {
    boolean isHead = isOnCircle(x, y, halfWidth, halfHeight, headSize, strokeWidth, headSquashY);
    boolean isLeftEye = isInCircle(x, y, eyePositionX, eyePositionY, eyeSize);
    boolean isRightEye = isInCircle(x, y, width - eyePositionX - 1, eyePositionY, eyeSize);
    boolean isMouth = isOnCircle(x, y, mouthPositionX, mouthPositionY, mouthSize, strokeWidth, 1) && y > mouthPositionY + mouthOffsetY;

    if (isLeftEye || isRightEye || isMouth || isHead) {
      result += "*";
    } else {
      result += ".";
    }

    result += " ";

    // Make sure the smiley face doesn't deform as the container changes width.
    charCount++;
    if (charCount % width === 0) {
      result += "\\\\n";
    }
  }
}

return result;`;