"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrameInformationWindow = FrameInformationWindow;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _profilingUtils = require("@kbn/profiling-utils");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _frames_summary = require("../frames_summary");
var _apm_transactions = require("./apm_transactions");
var _empty_frame = require("./empty_frame");
var _frame_information_ai_assistant = require("./frame_information_ai_assistant");
var _frame_information_panel = require("./frame_information_panel");
var _get_impact_rows = require("./get_impact_rows");
var _get_information_rows = require("./get_information_rows");
var _key_value_list = require("./key_value_list");
var _missing_symbols_callout = require("./missing_symbols_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/profiling/public/components/frame_information_window/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FrameInformationWindow({
  frame,
  showSymbolsStatus = true,
  comparisonFrame,
  comparisonRank,
  comparisonTotalSamples,
  comparisonTotalSeconds,
  totalSamples,
  totalSeconds,
  rank,
  compressed = false
}) {
  const [accordionState, setAccordionState] = (0, _react.useState)('closed');
  const calculateImpactEstimates = (0, _use_calculate_impact_estimates.useCalculateImpactEstimate)();
  if (!frame) {
    return /*#__PURE__*/_react.default.createElement(_empty_frame.EmptyFrame, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 12
      }
    });
  }
  const symbolStatus = (0, _profilingUtils.getFrameSymbolStatus)({
    sourceFilename: frame.sourceFileName,
    sourceLine: frame.sourceLine,
    exeFileName: frame.exeFileName
  });
  const {
    fileID,
    frameType,
    exeFileName,
    addressOrLine,
    functionName,
    sourceFileName,
    sourceLine,
    subGroups = {}
  } = frame;
  const informationRows = (0, _get_information_rows.getInformationRows)({
    fileID,
    frameType,
    exeFileName,
    addressOrLine,
    functionName,
    sourceFileName,
    sourceLine
  });
  const impactRows = (0, _get_impact_rows.getComparisonImpactRow)({
    base: {
      countInclusive: frame.countInclusive,
      countExclusive: frame.countExclusive,
      selfAnnualCO2Kgs: frame.selfAnnualCO2Kgs,
      totalAnnualCO2Kgs: frame.totalAnnualCO2Kgs,
      selfAnnualCostUSD: frame.selfAnnualCostUSD,
      totalAnnualCostUSD: frame.totalAnnualCostUSD,
      rank,
      totalSamples,
      totalSeconds,
      calculateImpactEstimates
    },
    comparison: comparisonFrame && comparisonTotalSamples !== undefined && comparisonTotalSeconds !== undefined ? {
      countInclusive: comparisonFrame.countInclusive,
      countExclusive: comparisonFrame.countExclusive,
      selfAnnualCO2Kgs: comparisonFrame.selfAnnualCO2Kgs,
      totalAnnualCO2Kgs: comparisonFrame.totalAnnualCO2Kgs,
      selfAnnualCostUSD: comparisonFrame.selfAnnualCostUSD,
      totalAnnualCostUSD: comparisonFrame.totalAnnualCostUSD,
      rank: comparisonRank,
      totalSamples: comparisonTotalSamples,
      totalSeconds: comparisonTotalSeconds,
      calculateImpactEstimates
    } : undefined
  });
  return /*#__PURE__*/_react.default.createElement(_frame_information_panel.FrameInformationPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, informationRows.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `informationRows_${item['data-test-subj']}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 21
      }
    }, item.value),
    description: item.label,
    titleSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_frame_information_ai_assistant.FrameInformationAIAssistant, {
    frame: frame,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }), showSymbolsStatus && symbolStatus !== _profilingUtils.FrameSymbolStatus.SYMBOLIZED && frame.frameType < _profilingUtils.FrameType.Root ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_missing_symbols_callout.MissingSymbolsCallout, {
    frameType: frame.frameType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  })) : null, (0, _lodash.isEmpty)(subGroups) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "apmTransactions",
    borders: "horizontal",
    buttonProps: {
      paddingSize: 'm'
    },
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "apmApp",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.apmTransactions', {
      defaultMessage: 'Distributed Tracing Correlation'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.apmTransactions.description', {
      defaultMessage: 'A curated view of APM services and transactions that call this function.'
    }))))),
    forceState: accordionState,
    onToggle: isOpen => setAccordionState(isOpen ? 'open' : 'closed'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, accordionState === 'open' ? /*#__PURE__*/_react.default.createElement(_apm_transactions.APMTransactions, {
    functionName: functionName,
    serviceNames: subGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_frames_summary.FramesSummary, {
    compressed: compressed,
    hasBorder: true,
    isLoading: false,
    baseValue: {
      totalCount: frame.countInclusive,
      scaleFactor: 1,
      // isNormalizedByTime ? baselineTime : baseline,
      totalAnnualCO2Kgs: frame.totalAnnualCO2Kgs,
      totalAnnualCostUSD: frame.totalAnnualCostUSD
    },
    comparisonValue: comparisonFrame ? {
      totalCount: comparisonFrame.countInclusive,
      scaleFactor: 1,
      // isNormalizedByTime ? baselineTime : baseline,
      totalAnnualCO2Kgs: comparisonFrame.totalAnnualCO2Kgs,
      totalAnnualCostUSD: comparisonFrame.totalAnnualCostUSD
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.impactEstimatesTitle', {
    defaultMessage: 'Impact estimates'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_key_value_list.KeyValueList, {
    "data-test-subj": "impactEstimates",
    rows: impactRows,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }))))));
}