"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupedIndexDetails = GroupedIndexDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _common2 = require("../../../../common");
var _label_with_hint = require("../../../components/label_with_hint");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/profiling/public/views/storage_explorer/data_breakdown/grouped_index_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const hintMap = {
  events: _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.events.hint', {
    defaultMessage: 'Universal Profiling samples linearly correlate with the probabilistic profiling value. The lower the probabilistic profiling value, the fewer samples are collected.'
  })
};
function GroupedIndexDetails({
  data = []
}) {
  const orderedIndexNames = ['stackframes', 'stacktraces', 'executables', 'metrics', 'events'];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, orderedIndexNames.map(indexName => {
    const stats = data.find(item => item.indexName === indexName);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: indexName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(IndexSizeItem, {
      indexName: indexName,
      docCount: stats === null || stats === void 0 ? void 0 : stats.docCount,
      sizeInBytes: stats === null || stats === void 0 ? void 0 : stats.sizeInBytes,
      hint: hintMap[indexName],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 13
      }
    }));
  }));
}
function IndexSizeItem({
  indexName,
  docCount,
  sizeInBytes,
  hint
}) {
  const theme = (0, _eui.useEuiTheme)();
  const indexLabel = (0, _utils.getGroupedIndexLabel)(indexName);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, hint ? /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
    label: indexLabel,
    hint: hint,
    labelSize: "xs",
    labelStyle: {
      fontWeight: 'bold'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      fontWeight: 'bold'
    },
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, indexLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      fontWeight: 'bold'
    },
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.size', {
    defaultMessage: 'Size'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    style: {
      backgroundColor: theme.euiTheme.colors.lightestShade,
      height: 41,
      alignItems: 'center',
      borderTop: `${theme.euiTheme.border.width.thin} solid ${theme.euiTheme.border.color}`,
      borderBottom: `${theme.euiTheme.border.width.thin} solid ${theme.euiTheme.border.color}`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      paddingLeft: 8
    },
    "data-test-subj": `${indexName}_docSize`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, docCount !== undefined ? (0, _common.asInteger)(docCount) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, _common2.NOT_AVAILABLE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      paddingLeft: 8
    },
    "data-test-subj": `${indexName}_size`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, sizeInBytes ? (0, _common.asDynamicBytes)(sizeInBytes) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, _common2.NOT_AVAILABLE_LABEL))));
}