"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisableReportConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/reporting/public/management/components/disable_report_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DisableReportConfirmationModalComponent = ({
  title,
  message,
  onCancel,
  onConfirm
}) => {
  const titleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    cancelButtonText: _i18n.i18n.translate('xpack.reporting.schedules.disable.cancel', {
      defaultMessage: 'Cancel'
    }),
    "data-test-subj": "confirm-disable-modal",
    defaultFocusedButton: "confirm",
    onCancel: onCancel,
    onConfirm: onConfirm,
    title: title,
    titleProps: {
      id: titleId
    },
    confirmButtonText: _i18n.i18n.translate('xpack.reporting.schedules.disable.confirm', {
      defaultMessage: 'Disable'
    }),
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, message);
};
DisableReportConfirmationModalComponent.displayName = 'DisableReportConfirmationModal';
const DisableReportConfirmationModal = exports.DisableReportConfirmationModal = /*#__PURE__*/_react.default.memo(DisableReportConfirmationModalComponent);