"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportInfoButton = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/reporting/public/management/components/report_info_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ReportInfoButton = ({
  job,
  onClick
}) => {
  let message = _i18n.i18n.translate('xpack.reporting.listing.table.reportInfoButtonTooltip', {
    defaultMessage: 'See report info.'
  });
  if (job.getError()) {
    message = _i18n.i18n.translate('xpack.reporting.listing.table.reportInfoAndErrorButtonTooltip', {
      defaultMessage: 'See report info and error message.'
    });
  } else if (job.getWarnings()) {
    message = _i18n.i18n.translate('xpack.reporting.listing.table.reportInfoAndWarningsButtonTooltip', {
      defaultMessage: 'See report info and warnings.'
    });
  }
  const showReportInfoCopy = _i18n.i18n.translate('xpack.reporting.listing.table.showReportInfoAriaLabel', {
    defaultMessage: 'Show report info'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    iconType: "info",
    color: "primary",
    "data-test-subj": "reportInfoButton",
    "aria-label": showReportInfoCopy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, showReportInfoCopy));
};
exports.ReportInfoButton = ReportInfoButton;